// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Custodian Remove Hold Parameter Set.
 */
public class EdiscoveryCustodianRemoveHoldParameterSet {
    /**
     * The ids.
     * 
     */
    @SerializedName(value = "ids", alternate = {"Ids"})
    @Expose
	@Nullable
    public java.util.List<String> ids;


    /**
     * Instiaciates a new EdiscoveryCustodianRemoveHoldParameterSet
     */
    public EdiscoveryCustodianRemoveHoldParameterSet() {}
    /**
     * Instiaciates a new EdiscoveryCustodianRemoveHoldParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected EdiscoveryCustodianRemoveHoldParameterSet(@Nonnull final EdiscoveryCustodianRemoveHoldParameterSetBuilder builder) {
        this.ids = builder.ids;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static EdiscoveryCustodianRemoveHoldParameterSetBuilder newBuilder() {
        return new EdiscoveryCustodianRemoveHoldParameterSetBuilder();
    }
    /**
     * Fluent builder for the EdiscoveryCustodianRemoveHoldParameterSet
     */
    public static final class EdiscoveryCustodianRemoveHoldParameterSetBuilder {
        /**
         * The ids parameter value
         */
        @Nullable
        protected java.util.List<String> ids;
        /**
         * Sets the Ids
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public EdiscoveryCustodianRemoveHoldParameterSetBuilder withIds(@Nullable final java.util.List<String> val) {
            this.ids = val;
            return this;
        }
        /**
         * Instanciates a new EdiscoveryCustodianRemoveHoldParameterSetBuilder
         */
        @Nullable
        protected EdiscoveryCustodianRemoveHoldParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public EdiscoveryCustodianRemoveHoldParameterSet build() {
            return new EdiscoveryCustodianRemoveHoldParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.ids != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("ids", ids));
        }
        return result;
    }
}
