// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AuditActor;
import com.microsoft.graph.models.AuditResource;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audit Event.
 */
public class AuditEvent extends Entity implements IJsonBackedObject {


    /**
     * The Activity.
     * Friendly name of the activity.
     */
    @SerializedName(value = "activity", alternate = {"Activity"})
    @Expose
	@Nullable
    public String activity;

    /**
     * The Activity Date Time.
     * The date time in UTC when the activity was performed.
     */
    @SerializedName(value = "activityDateTime", alternate = {"ActivityDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime activityDateTime;

    /**
     * The Activity Operation Type.
     * The HTTP operation type of the activity.
     */
    @SerializedName(value = "activityOperationType", alternate = {"ActivityOperationType"})
    @Expose
	@Nullable
    public String activityOperationType;

    /**
     * The Activity Result.
     * The result of the activity.
     */
    @SerializedName(value = "activityResult", alternate = {"ActivityResult"})
    @Expose
	@Nullable
    public String activityResult;

    /**
     * The Activity Type.
     * The type of activity that was being performed.
     */
    @SerializedName(value = "activityType", alternate = {"ActivityType"})
    @Expose
	@Nullable
    public String activityType;

    /**
     * The Actor.
     * AAD user and application that are associated with the audit event.
     */
    @SerializedName(value = "actor", alternate = {"Actor"})
    @Expose
	@Nullable
    public AuditActor actor;

    /**
     * The Category.
     * Audit category.
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public String category;

    /**
     * The Component Name.
     * Component name.
     */
    @SerializedName(value = "componentName", alternate = {"ComponentName"})
    @Expose
	@Nullable
    public String componentName;

    /**
     * The Correlation Id.
     * The client request Id that is used to correlate activity within the system.
     */
    @SerializedName(value = "correlationId", alternate = {"CorrelationId"})
    @Expose
	@Nullable
    public java.util.UUID correlationId;

    /**
     * The Display Name.
     * Event display name.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Resources.
     * Resources being modified.
     */
    @SerializedName(value = "resources", alternate = {"Resources"})
    @Expose
	@Nullable
    public java.util.List<AuditResource> resources;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
