// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.RolePermission;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Get Effective Permissions Parameter Set.
 */
public class DeviceManagementGetEffectivePermissionsParameterSet {
    /**
     * The scope.
     * 
     */
    @SerializedName(value = "scope", alternate = {"Scope"})
    @Expose
	@Nullable
    public String scope;


    /**
     * Instiaciates a new DeviceManagementGetEffectivePermissionsParameterSet
     */
    public DeviceManagementGetEffectivePermissionsParameterSet() {}
    /**
     * Instiaciates a new DeviceManagementGetEffectivePermissionsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected DeviceManagementGetEffectivePermissionsParameterSet(@Nonnull final DeviceManagementGetEffectivePermissionsParameterSetBuilder builder) {
        this.scope = builder.scope;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static DeviceManagementGetEffectivePermissionsParameterSetBuilder newBuilder() {
        return new DeviceManagementGetEffectivePermissionsParameterSetBuilder();
    }
    /**
     * Fluent builder for the DeviceManagementGetEffectivePermissionsParameterSet
     */
    public static final class DeviceManagementGetEffectivePermissionsParameterSetBuilder {
        /**
         * The scope parameter value
         */
        @Nullable
        protected String scope;
        /**
         * Sets the Scope
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public DeviceManagementGetEffectivePermissionsParameterSetBuilder withScope(@Nullable final String val) {
            this.scope = val;
            return this;
        }
        /**
         * Instanciates a new DeviceManagementGetEffectivePermissionsParameterSetBuilder
         */
        @Nullable
        protected DeviceManagementGetEffectivePermissionsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public DeviceManagementGetEffectivePermissionsParameterSet build() {
            return new DeviceManagementGetEffectivePermissionsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.scope != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("scope", scope));
        }
        return result;
    }
}
