// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AttributeSetCollectionPage;
import com.microsoft.graph.requests.CustomSecurityAttributeDefinitionCollectionPage;
import com.microsoft.graph.requests.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.IdentityProviderBaseCollectionPage;
import com.microsoft.graph.requests.OnPremisesDirectorySynchronizationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory.
 */
public class Directory extends Entity implements IJsonBackedObject {


    /**
     * The Administrative Units.
     * Conceptual container for user and group directory objects.
     */
    @SerializedName(value = "administrativeUnits", alternate = {"AdministrativeUnits"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AdministrativeUnitCollectionPage administrativeUnits;

    /**
     * The Attribute Sets.
     * 
     */
    @SerializedName(value = "attributeSets", alternate = {"AttributeSets"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AttributeSetCollectionPage attributeSets;

    /**
     * The Custom Security Attribute Definitions.
     * 
     */
    @SerializedName(value = "customSecurityAttributeDefinitions", alternate = {"CustomSecurityAttributeDefinitions"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.CustomSecurityAttributeDefinitionCollectionPage customSecurityAttributeDefinitions;

    /**
     * The Deleted Items.
     * Recently deleted items. Read-only. Nullable.
     */
    @SerializedName(value = "deletedItems", alternate = {"DeletedItems"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DirectoryObjectCollectionPage deletedItems;

    /**
     * The Federation Configurations.
     * Configure domain federation with organizations whose identity provider (IdP) supports either the SAML or WS-Fed protocol.
     */
    @SerializedName(value = "federationConfigurations", alternate = {"FederationConfigurations"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.IdentityProviderBaseCollectionPage federationConfigurations;

    /**
     * The On Premises Synchronization.
     * A container for on-premises directory synchronization functionalities that are available for the organization.
     */
    @SerializedName(value = "onPremisesSynchronization", alternate = {"OnPremisesSynchronization"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.OnPremisesDirectorySynchronizationCollectionPage onPremisesSynchronization;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("administrativeUnits")) {
            administrativeUnits = serializer.deserializeObject(json.get("administrativeUnits"), com.microsoft.graph.requests.AdministrativeUnitCollectionPage.class);
        }

        if (json.has("attributeSets")) {
            attributeSets = serializer.deserializeObject(json.get("attributeSets"), com.microsoft.graph.requests.AttributeSetCollectionPage.class);
        }

        if (json.has("customSecurityAttributeDefinitions")) {
            customSecurityAttributeDefinitions = serializer.deserializeObject(json.get("customSecurityAttributeDefinitions"), com.microsoft.graph.requests.CustomSecurityAttributeDefinitionCollectionPage.class);
        }

        if (json.has("deletedItems")) {
            deletedItems = serializer.deserializeObject(json.get("deletedItems"), com.microsoft.graph.requests.DirectoryObjectCollectionPage.class);
        }

        if (json.has("federationConfigurations")) {
            federationConfigurations = serializer.deserializeObject(json.get("federationConfigurations"), com.microsoft.graph.requests.IdentityProviderBaseCollectionPage.class);
        }

        if (json.has("onPremisesSynchronization")) {
            onPremisesSynchronization = serializer.deserializeObject(json.get("onPremisesSynchronization"), com.microsoft.graph.requests.OnPremisesDirectorySynchronizationCollectionPage.class);
        }
    }
}
