// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.List;
import com.microsoft.graph.models.ListItem;
import com.microsoft.graph.models.Permission;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.BaseItem;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared Drive Item.
 */
public class SharedDriveItem extends BaseItem implements IJsonBackedObject {


    /**
     * The Owner.
     * Information about the owner of the shared item being referenced.
     */
    @SerializedName(value = "owner", alternate = {"Owner"})
    @Expose
	@Nullable
    public IdentitySet owner;

    /**
     * The Drive Item.
     * Used to access the underlying driveItem
     */
    @SerializedName(value = "driveItem", alternate = {"DriveItem"})
    @Expose
	@Nullable
    public DriveItem driveItem;

    /**
     * The Items.
     * All driveItems contained in the sharing root. This collection cannot be enumerated.
     */
    @SerializedName(value = "items", alternate = {"Items"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.DriveItemCollectionPage items;

    /**
     * The List.
     * Used to access the underlying list
     */
    @SerializedName(value = "list", alternate = {"List"})
    @Expose
	@Nullable
    public List list;

    /**
     * The List Item.
     * Used to access the underlying listItem
     */
    @SerializedName(value = "listItem", alternate = {"ListItem"})
    @Expose
	@Nullable
    public ListItem listItem;

    /**
     * The Permission.
     * Used to access the permission representing the underlying sharing link
     */
    @SerializedName(value = "permission", alternate = {"Permission"})
    @Expose
	@Nullable
    public Permission permission;

    /**
     * The Root.
     * Used to access the underlying driveItem. Deprecated -- use driveItem instead.
     */
    @SerializedName(value = "root", alternate = {"Root"})
    @Expose
	@Nullable
    public DriveItem root;

    /**
     * The Site.
     * Used to access the underlying site
     */
    @SerializedName(value = "site", alternate = {"Site"})
    @Expose
	@Nullable
    public Site site;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("items")) {
            items = serializer.deserializeObject(json.get("items"), com.microsoft.graph.requests.DriveItemCollectionPage.class);
        }
    }
}
