// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.PresenceSetUserPreferredPresenceRequest;
import com.microsoft.graph.models.Presence;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.PresenceSetUserPreferredPresenceParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Presence Set User Preferred Presence Request Builder.
 */
public class PresenceSetUserPreferredPresenceRequestBuilder extends BaseActionRequestBuilder<Presence> {

    /**
     * The request builder for this PresenceSetUserPreferredPresence
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PresenceSetUserPreferredPresenceRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private PresenceSetUserPreferredPresenceParameterSet body;
    /**
     * The request builder for this PresenceSetUserPreferredPresence
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public PresenceSetUserPreferredPresenceRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final PresenceSetUserPreferredPresenceParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the PresenceSetUserPreferredPresenceRequest
     *
     * @param requestOptions the options for the request
     * @return the PresenceSetUserPreferredPresenceRequest instance
     */
    @Nonnull
    public PresenceSetUserPreferredPresenceRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the PresenceSetUserPreferredPresenceRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the PresenceSetUserPreferredPresenceRequest instance
     */
    @Nonnull
    public PresenceSetUserPreferredPresenceRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final PresenceSetUserPreferredPresenceRequest request = new PresenceSetUserPreferredPresenceRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
