/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.AccessPackage;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AccessPackageCollectionPage;
import com.microsoft.graph.requests.AccessPackageCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessPackageCollectionResponse;
import com.microsoft.graph.requests.AccessPackageRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccessPackageCollectionRequest
extends BaseEntityCollectionRequest<AccessPackage, AccessPackageCollectionResponse, AccessPackageCollectionPage> {
    public AccessPackageCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageCollectionResponse.class, AccessPackageCollectionPage.class, AccessPackageCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<AccessPackage> postAsync(@Nonnull AccessPackage newAccessPackage) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AccessPackageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newAccessPackage);
    }

    @Nonnull
    public AccessPackage post(@Nonnull AccessPackage newAccessPackage) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AccessPackageRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAccessPackage);
    }

    @Nonnull
    public AccessPackageCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public AccessPackageCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

