// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AttributeMapping;
import com.microsoft.graph.models.ObjectFlowTypes;
import com.microsoft.graph.models.ObjectMappingMetadataEntry;
import com.microsoft.graph.models.Filter;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Object Mapping.
 */
public class ObjectMapping implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Attribute Mappings.
     * 
     */
    @SerializedName(value = "attributeMappings", alternate = {"AttributeMappings"})
    @Expose
	@Nullable
    public java.util.List<AttributeMapping> attributeMappings;

    /**
     * The Enabled.
     * 
     */
    @SerializedName(value = "enabled", alternate = {"Enabled"})
    @Expose
	@Nullable
    public Boolean enabled;

    /**
     * The Flow Types.
     * 
     */
    @SerializedName(value = "flowTypes", alternate = {"FlowTypes"})
    @Expose
	@Nullable
    public EnumSet<ObjectFlowTypes> flowTypes;

    /**
     * The Metadata.
     * 
     */
    @SerializedName(value = "metadata", alternate = {"Metadata"})
    @Expose
	@Nullable
    public java.util.List<ObjectMappingMetadataEntry> metadata;

    /**
     * The Name.
     * 
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Scope.
     * 
     */
    @SerializedName(value = "scope", alternate = {"Scope"})
    @Expose
	@Nullable
    public Filter scope;

    /**
     * The Source Object Name.
     * 
     */
    @SerializedName(value = "sourceObjectName", alternate = {"SourceObjectName"})
    @Expose
	@Nullable
    public String sourceObjectName;

    /**
     * The Target Object Name.
     * 
     */
    @SerializedName(value = "targetObjectName", alternate = {"TargetObjectName"})
    @Expose
	@Nullable
    public String targetObjectName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
