// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.AlertEvidence;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mail Cluster Evidence.
 */
public class MailClusterEvidence extends AlertEvidence implements IJsonBackedObject {


    /**
     * The Cluster By.
     * The clustering logic of the emails inside the cluster.
     */
    @SerializedName(value = "clusterBy", alternate = {"ClusterBy"})
    @Expose
	@Nullable
    public String clusterBy;

    /**
     * The Cluster By Value.
     * The value utilized to cluster the similar emails.
     */
    @SerializedName(value = "clusterByValue", alternate = {"ClusterByValue"})
    @Expose
	@Nullable
    public String clusterByValue;

    /**
     * The Email Count.
     * Count of emails in the email cluster.
     */
    @SerializedName(value = "emailCount", alternate = {"EmailCount"})
    @Expose
	@Nullable
    public Long emailCount;

    /**
     * The Network Message Ids.
     * Unique identifiers for the emails in the cluster, generated by Microsoft 365.
     */
    @SerializedName(value = "networkMessageIds", alternate = {"NetworkMessageIds"})
    @Expose
	@Nullable
    public java.util.List<String> networkMessageIds;

    /**
     * The Query.
     * The query used to identify the email cluster.
     */
    @SerializedName(value = "query", alternate = {"Query"})
    @Expose
	@Nullable
    public String query;

    /**
     * The Urn.
     * Uniform resource name (URN) of the automated investigation where the cluster was identified.
     */
    @SerializedName(value = "urn", alternate = {"Urn"})
    @Expose
	@Nullable
    public String urn;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
