// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.ediscovery.models.CaseStatus;
import com.microsoft.graph.ediscovery.models.Custodian;
import com.microsoft.graph.ediscovery.models.LegalHold;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;
import com.microsoft.graph.ediscovery.models.CaseOperation;
import com.microsoft.graph.ediscovery.models.ReviewSet;
import com.microsoft.graph.ediscovery.models.CaseSettings;
import com.microsoft.graph.ediscovery.models.SourceCollection;
import com.microsoft.graph.ediscovery.models.Tag;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.ediscovery.requests.CustodianCollectionPage;
import com.microsoft.graph.ediscovery.requests.LegalHoldCollectionPage;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceCollectionPage;
import com.microsoft.graph.ediscovery.requests.CaseOperationCollectionPage;
import com.microsoft.graph.ediscovery.requests.ReviewSetCollectionPage;
import com.microsoft.graph.ediscovery.requests.SourceCollectionCollectionPage;
import com.microsoft.graph.ediscovery.requests.TagCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Case.
 */
public class Case extends Entity implements IJsonBackedObject {


    /**
     * The Closed By.
     * The user who closed the case.
     */
    @SerializedName(value = "closedBy", alternate = {"ClosedBy"})
    @Expose
	@Nullable
    public IdentitySet closedBy;

    /**
     * The Closed Date Time.
     * The date and time when the case was closed. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "closedDateTime", alternate = {"ClosedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime closedDateTime;

    /**
     * The Created Date Time.
     * The date and time when the entity was created. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * The case description.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The case name.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The External Id.
     * The external case number for customer reference.
     */
    @SerializedName(value = "externalId", alternate = {"ExternalId"})
    @Expose
	@Nullable
    public String externalId;

    /**
     * The Last Modified By.
     * The last user who modified the entity.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * The latest date and time when the case was modified. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Status.
     * The case status. Possible values are unknown, active, pendingDelete, closing, closed, and closedWithError. For details, see the following table.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public CaseStatus status;

    /**
     * The Custodians.
     * Returns a list of case custodian objects for this case.  Nullable.
     */
    @SerializedName(value = "custodians", alternate = {"Custodians"})
    @Expose
	@Nullable
    public CustodianCollectionPage custodians;

    /**
     * The Legal Holds.
     * Returns a list of case legalHold objects for this case.  Nullable.
     */
    @SerializedName(value = "legalHolds", alternate = {"LegalHolds"})
    @Expose
	@Nullable
    public LegalHoldCollectionPage legalHolds;

    /**
     * The Noncustodial Data Sources.
     * Returns a list of case noncustodialDataSource objects for this case.  Nullable.
     */
    @SerializedName(value = "noncustodialDataSources", alternate = {"NoncustodialDataSources"})
    @Expose
	@Nullable
    public NoncustodialDataSourceCollectionPage noncustodialDataSources;

    /**
     * The Operations.
     * Returns a list of case operation objects for this case. Nullable.
     */
    @SerializedName(value = "operations", alternate = {"Operations"})
    @Expose
	@Nullable
    public CaseOperationCollectionPage operations;

    /**
     * The Review Sets.
     * Returns a list of reviewSet objects in the case. Read-only. Nullable.
     */
    @SerializedName(value = "reviewSets", alternate = {"ReviewSets"})
    @Expose
	@Nullable
    public ReviewSetCollectionPage reviewSets;

    /**
     * The Settings.
     * 
     */
    @SerializedName(value = "settings", alternate = {"Settings"})
    @Expose
	@Nullable
    public CaseSettings settings;

    /**
     * The Source Collections.
     * Returns a list of sourceCollection objects associated with this case.
     */
    @SerializedName(value = "sourceCollections", alternate = {"SourceCollections"})
    @Expose
	@Nullable
    public SourceCollectionCollectionPage sourceCollections;

    /**
     * The Tags.
     * Returns a list of tag objects associated to this case.
     */
    @SerializedName(value = "tags", alternate = {"Tags"})
    @Expose
	@Nullable
    public TagCollectionPage tags;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("custodians")) {
            custodians = serializer.deserializeObject(json.get("custodians"), CustodianCollectionPage.class);
        }

        if (json.has("legalHolds")) {
            legalHolds = serializer.deserializeObject(json.get("legalHolds"), LegalHoldCollectionPage.class);
        }

        if (json.has("noncustodialDataSources")) {
            noncustodialDataSources = serializer.deserializeObject(json.get("noncustodialDataSources"), NoncustodialDataSourceCollectionPage.class);
        }

        if (json.has("operations")) {
            operations = serializer.deserializeObject(json.get("operations"), CaseOperationCollectionPage.class);
        }

        if (json.has("reviewSets")) {
            reviewSets = serializer.deserializeObject(json.get("reviewSets"), ReviewSetCollectionPage.class);
        }

        if (json.has("sourceCollections")) {
            sourceCollections = serializer.deserializeObject(json.get("sourceCollections"), SourceCollectionCollectionPage.class);
        }

        if (json.has("tags")) {
            tags = serializer.deserializeObject(json.get("tags"), TagCollectionPage.class);
        }
    }
}
