// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.ediscovery.models.LegalHoldStatus;
import com.microsoft.graph.ediscovery.models.SiteSource;
import com.microsoft.graph.ediscovery.models.UserSource;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionPage;
import com.microsoft.graph.ediscovery.requests.UserSourceCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Legal Hold.
 */
public class LegalHold extends Entity implements IJsonBackedObject {


    /**
     * The Content Query.
     * KQL query that specifies content to be held in the specified locations. To learn more, see Keyword queries and search conditions for Content Search and eDiscovery.  To hold all content in the specified locations, leave contentQuery blank.
     */
    @SerializedName(value = "contentQuery", alternate = {"ContentQuery"})
    @Expose
	@Nullable
    public String contentQuery;

    /**
     * The Created By.
     * The user who created the legal hold.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public IdentitySet createdBy;

    /**
     * The Created Date Time.
     * The date and time the legal hold was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * The legal hold description.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name of the legal hold.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Errors.
     * Lists any errors that happened while placing the hold.
     */
    @SerializedName(value = "errors", alternate = {"Errors"})
    @Expose
	@Nullable
    public java.util.List<String> errors;

    /**
     * The Is Enabled.
     * Indicates whether the hold is enabled and actively holding content.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Last Modified By.
     * the user who last modified the legal hold.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * The date and time the legal hold was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Status.
     * The status of the legal hold. Possible values are: Pending, Error, Success, UnknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public LegalHoldStatus status;

    /**
     * The Site Sources.
     * Data source entity for SharePoint sites associated with the legal hold.
     */
    @SerializedName(value = "siteSources", alternate = {"SiteSources"})
    @Expose
	@Nullable
    public SiteSourceCollectionPage siteSources;

    /**
     * The User Sources.
     * Data source entity for a the legal hold. This is the container for a mailbox and OneDrive for Business site.
     */
    @SerializedName(value = "userSources", alternate = {"UserSources"})
    @Expose
	@Nullable
    public UserSourceCollectionPage userSources;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("siteSources")) {
            siteSources = serializer.deserializeObject(json.get("siteSources"), SiteSourceCollectionPage.class);
        }

        if (json.has("userSources")) {
            userSources = serializer.deserializeObject(json.get("userSources"), UserSourceCollectionPage.class);
        }
    }
}
