// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.models;

import com.microsoft.graph.ediscovery.models.Tag;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Review Set Query Apply Tags Parameter Set.
 */
public class ReviewSetQueryApplyTagsParameterSet {
    /**
     * The tags To Add.
     * 
     */
    @SerializedName(value = "tagsToAdd", alternate = {"TagsToAdd"})
    @Expose
	@Nullable
    public java.util.List<Tag> tagsToAdd;

    /**
     * The tags To Remove.
     * 
     */
    @SerializedName(value = "tagsToRemove", alternate = {"TagsToRemove"})
    @Expose
	@Nullable
    public java.util.List<Tag> tagsToRemove;


    /**
     * Instiaciates a new ReviewSetQueryApplyTagsParameterSet
     */
    public ReviewSetQueryApplyTagsParameterSet() {}
    /**
     * Instiaciates a new ReviewSetQueryApplyTagsParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ReviewSetQueryApplyTagsParameterSet(@Nonnull final ReviewSetQueryApplyTagsParameterSetBuilder builder) {
        this.tagsToAdd = builder.tagsToAdd;
        this.tagsToRemove = builder.tagsToRemove;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ReviewSetQueryApplyTagsParameterSetBuilder newBuilder() {
        return new ReviewSetQueryApplyTagsParameterSetBuilder();
    }
    /**
     * Fluent builder for the ReviewSetQueryApplyTagsParameterSet
     */
    public static final class ReviewSetQueryApplyTagsParameterSetBuilder {
        /**
         * The tagsToAdd parameter value
         */
        @Nullable
        protected java.util.List<Tag> tagsToAdd;
        /**
         * Sets the TagsToAdd
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReviewSetQueryApplyTagsParameterSetBuilder withTagsToAdd(@Nullable final java.util.List<Tag> val) {
            this.tagsToAdd = val;
            return this;
        }
        /**
         * The tagsToRemove parameter value
         */
        @Nullable
        protected java.util.List<Tag> tagsToRemove;
        /**
         * Sets the TagsToRemove
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ReviewSetQueryApplyTagsParameterSetBuilder withTagsToRemove(@Nullable final java.util.List<Tag> val) {
            this.tagsToRemove = val;
            return this;
        }
        /**
         * Instanciates a new ReviewSetQueryApplyTagsParameterSetBuilder
         */
        @Nullable
        protected ReviewSetQueryApplyTagsParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ReviewSetQueryApplyTagsParameterSet build() {
            return new ReviewSetQueryApplyTagsParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.tagsToAdd != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("tagsToAdd", tagsToAdd));
        }
        if(this.tagsToRemove != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("tagsToRemove", tagsToRemove));
        }
        return result;
    }
}
