// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.ediscovery.models.DataSourceScopes;
import com.microsoft.graph.ediscovery.models.DataSource;
import com.microsoft.graph.ediscovery.models.EstimateStatisticsOperation;
import com.microsoft.graph.ediscovery.models.NoncustodialDataSource;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.ediscovery.requests.DataSourceCollectionPage;
import com.microsoft.graph.ediscovery.requests.NoncustodialDataSourceCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Source Collection.
 */
public class SourceCollection extends Entity implements IJsonBackedObject {


    /**
     * The Content Query.
     * The query string in KQL (Keyword Query Language) query. For details, see Keyword queries and search conditions for Content Search and eDiscovery.  You can refine searches by using fields paired with values; for example, subject:'Quarterly Financials' AND Date&amp;gt;=06/01/2016 AND Date&amp;lt;=07/01/2016
     */
    @SerializedName(value = "contentQuery", alternate = {"ContentQuery"})
    @Expose
	@Nullable
    public String contentQuery;

    /**
     * The Created By.
     * The user who created the sourceCollection.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public IdentitySet createdBy;

    /**
     * The Created Date Time.
     * The date and time the sourceCollection was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Data Source Scopes.
     * When specified, the collection will span across a service for an entire workload. Possible values are: none,allTenantMailboxes,allTenantSites,allCaseCustodians,allCaseNoncustodialDataSources.
     */
    @SerializedName(value = "dataSourceScopes", alternate = {"DataSourceScopes"})
    @Expose
	@Nullable
    public EnumSet<DataSourceScopes> dataSourceScopes;

    /**
     * The Description.
     * The description of the sourceCollection
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The display name of the sourceCollection
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Last Modified By.
     * The last user who modified the sourceCollection.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * The last date and time the sourceCollection was modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Additional Sources.
     * Adds an additional source to the sourceCollection.
     */
    @SerializedName(value = "additionalSources", alternate = {"AdditionalSources"})
    @Expose
	@Nullable
    public DataSourceCollectionPage additionalSources;

    /**
     * The Custodian Sources.
     * Custodian sources that are included in the sourceCollection.
     */
	@Nullable
    public DataSourceCollectionPage custodianSources;

    /**
     * The Last Estimate Statistics Operation.
     * The last estimate operation associated with the sourceCollection.
     */
    @SerializedName(value = "lastEstimateStatisticsOperation", alternate = {"LastEstimateStatisticsOperation"})
    @Expose
	@Nullable
    public EstimateStatisticsOperation lastEstimateStatisticsOperation;

    /**
     * The Noncustodial Sources.
     * noncustodialDataSource sources that are included in the sourceCollection
     */
	@Nullable
    public NoncustodialDataSourceCollectionPage noncustodialSources;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("additionalSources")) {
            additionalSources = serializer.deserializeObject(json.get("additionalSources"), DataSourceCollectionPage.class);
        }

        if (json.has("custodianSources")) {
            custodianSources = serializer.deserializeObject(json.get("custodianSources"), DataSourceCollectionPage.class);
        }

        if (json.has("noncustodialSources")) {
            noncustodialSources = serializer.deserializeObject(json.get("noncustodialSources"), NoncustodialDataSourceCollectionPage.class);
        }
    }
}
