// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.CaseIndexOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Case Index Operation Request.
 */
public class CaseIndexOperationRequest extends BaseRequest<CaseIndexOperation> {
	
    /**
     * The request for the CaseIndexOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CaseIndexOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CaseIndexOperation.class);
    }

    /**
     * Gets the CaseIndexOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseIndexOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CaseIndexOperation from the service
     *
     * @return the CaseIndexOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseIndexOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseIndexOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CaseIndexOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CaseIndexOperation with a source
     *
     * @param sourceCaseIndexOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseIndexOperation> patchAsync(@Nonnull final CaseIndexOperation sourceCaseIndexOperation) {
        return sendAsync(HttpMethod.PATCH, sourceCaseIndexOperation);
    }

    /**
     * Patches this CaseIndexOperation with a source
     *
     * @param sourceCaseIndexOperation the source object with updates
     * @return the updated CaseIndexOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseIndexOperation patch(@Nonnull final CaseIndexOperation sourceCaseIndexOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceCaseIndexOperation);
    }

    /**
     * Creates a CaseIndexOperation with a new object
     *
     * @param newCaseIndexOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseIndexOperation> postAsync(@Nonnull final CaseIndexOperation newCaseIndexOperation) {
        return sendAsync(HttpMethod.POST, newCaseIndexOperation);
    }

    /**
     * Creates a CaseIndexOperation with a new object
     *
     * @param newCaseIndexOperation the new object to create
     * @return the created CaseIndexOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseIndexOperation post(@Nonnull final CaseIndexOperation newCaseIndexOperation) throws ClientException {
        return send(HttpMethod.POST, newCaseIndexOperation);
    }

    /**
     * Creates a CaseIndexOperation with a new object
     *
     * @param newCaseIndexOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseIndexOperation> putAsync(@Nonnull final CaseIndexOperation newCaseIndexOperation) {
        return sendAsync(HttpMethod.PUT, newCaseIndexOperation);
    }

    /**
     * Creates a CaseIndexOperation with a new object
     *
     * @param newCaseIndexOperation the object to create/update
     * @return the created CaseIndexOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseIndexOperation put(@Nonnull final CaseIndexOperation newCaseIndexOperation) throws ClientException {
        return send(HttpMethod.PUT, newCaseIndexOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CaseIndexOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CaseIndexOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

