// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.CaseSettings;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Case Settings Request.
 */
public class CaseSettingsRequest extends BaseRequest<CaseSettings> {
	
    /**
     * The request for the CaseSettings
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CaseSettingsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CaseSettings.class);
    }

    /**
     * Gets the CaseSettings from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseSettings> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CaseSettings from the service
     *
     * @return the CaseSettings from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseSettings get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseSettings> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CaseSettings delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CaseSettings with a source
     *
     * @param sourceCaseSettings the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseSettings> patchAsync(@Nonnull final CaseSettings sourceCaseSettings) {
        return sendAsync(HttpMethod.PATCH, sourceCaseSettings);
    }

    /**
     * Patches this CaseSettings with a source
     *
     * @param sourceCaseSettings the source object with updates
     * @return the updated CaseSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseSettings patch(@Nonnull final CaseSettings sourceCaseSettings) throws ClientException {
        return send(HttpMethod.PATCH, sourceCaseSettings);
    }

    /**
     * Creates a CaseSettings with a new object
     *
     * @param newCaseSettings the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseSettings> postAsync(@Nonnull final CaseSettings newCaseSettings) {
        return sendAsync(HttpMethod.POST, newCaseSettings);
    }

    /**
     * Creates a CaseSettings with a new object
     *
     * @param newCaseSettings the new object to create
     * @return the created CaseSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseSettings post(@Nonnull final CaseSettings newCaseSettings) throws ClientException {
        return send(HttpMethod.POST, newCaseSettings);
    }

    /**
     * Creates a CaseSettings with a new object
     *
     * @param newCaseSettings the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CaseSettings> putAsync(@Nonnull final CaseSettings newCaseSettings) {
        return sendAsync(HttpMethod.PUT, newCaseSettings);
    }

    /**
     * Creates a CaseSettings with a new object
     *
     * @param newCaseSettings the object to create/update
     * @return the created CaseSettings
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CaseSettings put(@Nonnull final CaseSettings newCaseSettings) throws ClientException {
        return send(HttpMethod.PUT, newCaseSettings);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CaseSettingsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CaseSettingsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

