// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.Custodian;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.SiteSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UnifiedGroupSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UnifiedGroupSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custodian Request Builder.
 */
public class CustodianRequestBuilder extends BaseRequestBuilder<Custodian> {

    /**
     * The request builder for the Custodian
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CustodianRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the CustodianRequest instance
     */
    @Nonnull
    public CustodianRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the CustodianRequest instance
     */
    @Nonnull
    public CustodianRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.ediscovery.requests.CustodianRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for CaseIndexOperation
     *
     * @return the CaseIndexOperationWithReferenceRequestBuilder instance
     */
    @Nonnull
    public CaseIndexOperationWithReferenceRequestBuilder lastIndexOperation() {
        return new CaseIndexOperationWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("lastIndexOperation"), getClient(), null);
    }
    /**
     *  Gets a request builder for the SiteSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public SiteSourceCollectionRequestBuilder siteSources() {
        return new SiteSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("siteSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the SiteSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public SiteSourceRequestBuilder siteSources(@Nonnull final String id) {
        return new SiteSourceRequestBuilder(getRequestUrlWithAdditionalSegment("siteSources") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UnifiedGroupSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public UnifiedGroupSourceCollectionRequestBuilder unifiedGroupSources() {
        return new UnifiedGroupSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("unifiedGroupSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the UnifiedGroupSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public UnifiedGroupSourceRequestBuilder unifiedGroupSources(@Nonnull final String id) {
        return new UnifiedGroupSourceRequestBuilder(getRequestUrlWithAdditionalSegment("unifiedGroupSources") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the UserSource collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public UserSourceCollectionRequestBuilder userSources() {
        return new UserSourceCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("userSources"), getClient(), null);
    }

    /**
     * Gets a request builder for the UserSource item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public UserSourceRequestBuilder userSources(@Nonnull final String id) {
        return new UserSourceRequestBuilder(getRequestUrlWithAdditionalSegment("userSources") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public CustodianActivateRequestBuilder activate() {
        return new CustodianActivateRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.ediscovery.activate"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public CustodianReleaseRequestBuilder release() {
        return new CustodianReleaseRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.ediscovery.release"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public CustodianUpdateIndexRequestBuilder updateIndex() {
        return new CustodianUpdateIndexRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.ediscovery.updateIndex"), getClient(), null);
    }
}
