// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.ediscovery.models.LegalHold;
import com.microsoft.graph.ediscovery.requests.SiteSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.SiteSourceRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.UserSourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Legal Hold Request.
 */
public class LegalHoldRequest extends BaseRequest<LegalHold> {
	
    /**
     * The request for the LegalHold
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LegalHoldRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LegalHold.class);
    }

    /**
     * Gets the LegalHold from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LegalHold> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LegalHold from the service
     *
     * @return the LegalHold from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LegalHold get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LegalHold> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LegalHold delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LegalHold with a source
     *
     * @param sourceLegalHold the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LegalHold> patchAsync(@Nonnull final LegalHold sourceLegalHold) {
        return sendAsync(HttpMethod.PATCH, sourceLegalHold);
    }

    /**
     * Patches this LegalHold with a source
     *
     * @param sourceLegalHold the source object with updates
     * @return the updated LegalHold
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LegalHold patch(@Nonnull final LegalHold sourceLegalHold) throws ClientException {
        return send(HttpMethod.PATCH, sourceLegalHold);
    }

    /**
     * Creates a LegalHold with a new object
     *
     * @param newLegalHold the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LegalHold> postAsync(@Nonnull final LegalHold newLegalHold) {
        return sendAsync(HttpMethod.POST, newLegalHold);
    }

    /**
     * Creates a LegalHold with a new object
     *
     * @param newLegalHold the new object to create
     * @return the created LegalHold
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LegalHold post(@Nonnull final LegalHold newLegalHold) throws ClientException {
        return send(HttpMethod.POST, newLegalHold);
    }

    /**
     * Creates a LegalHold with a new object
     *
     * @param newLegalHold the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LegalHold> putAsync(@Nonnull final LegalHold newLegalHold) {
        return sendAsync(HttpMethod.PUT, newLegalHold);
    }

    /**
     * Creates a LegalHold with a new object
     *
     * @param newLegalHold the object to create/update
     * @return the created LegalHold
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LegalHold put(@Nonnull final LegalHold newLegalHold) throws ClientException {
        return send(HttpMethod.PUT, newLegalHold);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LegalHoldRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LegalHoldRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

