// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.OnenotePatchContentCommand;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Page Onenote Patch Content Parameter Set.
 */
public class OnenotePageOnenotePatchContentParameterSet {
    /**
     * The commands.
     * 
     */
    @SerializedName(value = "commands", alternate = {"Commands"})
    @Expose
	@Nullable
    public java.util.List<OnenotePatchContentCommand> commands;


    /**
     * Instiaciates a new OnenotePageOnenotePatchContentParameterSet
     */
    public OnenotePageOnenotePatchContentParameterSet() {}
    /**
     * Instiaciates a new OnenotePageOnenotePatchContentParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected OnenotePageOnenotePatchContentParameterSet(@Nonnull final OnenotePageOnenotePatchContentParameterSetBuilder builder) {
        this.commands = builder.commands;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static OnenotePageOnenotePatchContentParameterSetBuilder newBuilder() {
        return new OnenotePageOnenotePatchContentParameterSetBuilder();
    }
    /**
     * Fluent builder for the OnenotePageOnenotePatchContentParameterSet
     */
    public static final class OnenotePageOnenotePatchContentParameterSetBuilder {
        /**
         * The commands parameter value
         */
        @Nullable
        protected java.util.List<OnenotePatchContentCommand> commands;
        /**
         * Sets the Commands
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public OnenotePageOnenotePatchContentParameterSetBuilder withCommands(@Nullable final java.util.List<OnenotePatchContentCommand> val) {
            this.commands = val;
            return this;
        }
        /**
         * Instanciates a new OnenotePageOnenotePatchContentParameterSetBuilder
         */
        @Nullable
        protected OnenotePageOnenotePatchContentParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public OnenotePageOnenotePatchContentParameterSet build() {
            return new OnenotePageOnenotePatchContentParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.commands != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("commands", commands));
        }
        return result;
    }
}
