// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Autopilot Device Identity Update Device Properties Parameter Set.
 */
public class WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet {
    /**
     * The user Principal Name.
     * 
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;

    /**
     * The addressable User Name.
     * 
     */
    @SerializedName(value = "addressableUserName", alternate = {"AddressableUserName"})
    @Expose
	@Nullable
    public String addressableUserName;

    /**
     * The group Tag.
     * 
     */
    @SerializedName(value = "groupTag", alternate = {"GroupTag"})
    @Expose
	@Nullable
    public String groupTag;

    /**
     * The display Name.
     * 
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;


    /**
     * Instiaciates a new WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet
     */
    public WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet() {}
    /**
     * Instiaciates a new WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet(@Nonnull final WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder builder) {
        this.userPrincipalName = builder.userPrincipalName;
        this.addressableUserName = builder.addressableUserName;
        this.groupTag = builder.groupTag;
        this.displayName = builder.displayName;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder newBuilder() {
        return new WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder();
    }
    /**
     * Fluent builder for the WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet
     */
    public static final class WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder {
        /**
         * The userPrincipalName parameter value
         */
        @Nullable
        protected String userPrincipalName;
        /**
         * Sets the UserPrincipalName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder withUserPrincipalName(@Nullable final String val) {
            this.userPrincipalName = val;
            return this;
        }
        /**
         * The addressableUserName parameter value
         */
        @Nullable
        protected String addressableUserName;
        /**
         * Sets the AddressableUserName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder withAddressableUserName(@Nullable final String val) {
            this.addressableUserName = val;
            return this;
        }
        /**
         * The groupTag parameter value
         */
        @Nullable
        protected String groupTag;
        /**
         * Sets the GroupTag
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder withGroupTag(@Nullable final String val) {
            this.groupTag = val;
            return this;
        }
        /**
         * The displayName parameter value
         */
        @Nullable
        protected String displayName;
        /**
         * Sets the DisplayName
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder withDisplayName(@Nullable final String val) {
            this.displayName = val;
            return this;
        }
        /**
         * Instanciates a new WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder
         */
        @Nullable
        protected WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet build() {
            return new WindowsAutopilotDeviceIdentityUpdateDevicePropertiesParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.userPrincipalName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("userPrincipalName", userPrincipalName));
        }
        if(this.addressableUserName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("addressableUserName", addressableUserName));
        }
        if(this.groupTag != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("groupTag", groupTag));
        }
        if(this.displayName != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("displayName", displayName));
        }
        return result;
    }
}
