// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookSortField;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Sort Apply Parameter Set.
 */
public class WorkbookRangeSortApplyParameterSet {
    /**
     * The fields.
     * 
     */
    @SerializedName(value = "fields", alternate = {"Fields"})
    @Expose
	@Nullable
    public java.util.List<WorkbookSortField> fields;

    /**
     * The match Case.
     * 
     */
    @SerializedName(value = "matchCase", alternate = {"MatchCase"})
    @Expose
	@Nullable
    public Boolean matchCase;

    /**
     * The has Headers.
     * 
     */
    @SerializedName(value = "hasHeaders", alternate = {"HasHeaders"})
    @Expose
	@Nullable
    public Boolean hasHeaders;

    /**
     * The orientation.
     * 
     */
    @SerializedName(value = "orientation", alternate = {"Orientation"})
    @Expose
	@Nullable
    public String orientation;

    /**
     * The method.
     * 
     */
    @SerializedName(value = "method", alternate = {"Method"})
    @Expose
	@Nullable
    public String method;


    /**
     * Instiaciates a new WorkbookRangeSortApplyParameterSet
     */
    public WorkbookRangeSortApplyParameterSet() {}
    /**
     * Instiaciates a new WorkbookRangeSortApplyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookRangeSortApplyParameterSet(@Nonnull final WorkbookRangeSortApplyParameterSetBuilder builder) {
        this.fields = builder.fields;
        this.matchCase = builder.matchCase;
        this.hasHeaders = builder.hasHeaders;
        this.orientation = builder.orientation;
        this.method = builder.method;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookRangeSortApplyParameterSetBuilder newBuilder() {
        return new WorkbookRangeSortApplyParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookRangeSortApplyParameterSet
     */
    public static final class WorkbookRangeSortApplyParameterSetBuilder {
        /**
         * The fields parameter value
         */
        @Nullable
        protected java.util.List<WorkbookSortField> fields;
        /**
         * Sets the Fields
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeSortApplyParameterSetBuilder withFields(@Nullable final java.util.List<WorkbookSortField> val) {
            this.fields = val;
            return this;
        }
        /**
         * The matchCase parameter value
         */
        @Nullable
        protected Boolean matchCase;
        /**
         * Sets the MatchCase
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeSortApplyParameterSetBuilder withMatchCase(@Nullable final Boolean val) {
            this.matchCase = val;
            return this;
        }
        /**
         * The hasHeaders parameter value
         */
        @Nullable
        protected Boolean hasHeaders;
        /**
         * Sets the HasHeaders
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeSortApplyParameterSetBuilder withHasHeaders(@Nullable final Boolean val) {
            this.hasHeaders = val;
            return this;
        }
        /**
         * The orientation parameter value
         */
        @Nullable
        protected String orientation;
        /**
         * Sets the Orientation
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeSortApplyParameterSetBuilder withOrientation(@Nullable final String val) {
            this.orientation = val;
            return this;
        }
        /**
         * The method parameter value
         */
        @Nullable
        protected String method;
        /**
         * Sets the Method
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookRangeSortApplyParameterSetBuilder withMethod(@Nullable final String val) {
            this.method = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookRangeSortApplyParameterSetBuilder
         */
        @Nullable
        protected WorkbookRangeSortApplyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookRangeSortApplyParameterSet build() {
            return new WorkbookRangeSortApplyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.fields != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("fields", fields));
        }
        if(this.matchCase != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("matchCase", matchCase));
        }
        if(this.hasHeaders != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("hasHeaders", hasHeaders));
        }
        if(this.orientation != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("orientation", orientation));
        }
        if(this.method != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("method", method));
        }
        return result;
    }
}
