// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationSchool;
import com.microsoft.graph.models.EducationClass;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.EducationClassCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.EducationClassCollectionWithReferencesPage;
import com.microsoft.graph.requests.EducationClassCollectionResponse;
import com.microsoft.graph.models.EducationClass;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Class Collection With References Page.
 */
public class EducationClassCollectionWithReferencesPage extends BaseCollectionPage<EducationClass, EducationClassCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for EducationClass
     *
     * @param response the serialized EducationClassCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public EducationClassCollectionWithReferencesPage(@Nonnull final EducationClassCollectionResponse response, @Nullable final EducationClassCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for EducationClass
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public EducationClassCollectionWithReferencesPage(@Nonnull final java.util.List<EducationClass> pageContents, @Nullable final EducationClassCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
