// Template Source: BaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Site;
import com.microsoft.graph.models.ItemActivityStat;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.requests.ItemAnalyticsWithReferenceRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.DriveCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.BaseItemCollectionRequestBuilder;
import com.microsoft.graph.requests.BaseItemRequestBuilder;
import com.microsoft.graph.requests.ListCollectionRequestBuilder;
import com.microsoft.graph.requests.ListRequestBuilder;
import com.microsoft.graph.requests.PermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.PermissionRequestBuilder;
import com.microsoft.graph.requests.SiteCollectionRequestBuilder;
import com.microsoft.graph.requests.SiteRequestBuilder;
import com.microsoft.graph.termstore.requests.StoreRequestBuilder;
import com.microsoft.graph.termstore.requests.StoreCollectionRequestBuilder;
import com.microsoft.graph.requests.OnenoteRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseWithReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site With Reference Request.
 */
public class SiteWithReferenceRequest extends BaseWithReferenceRequest<Site> {

    /**
     * The request for the Site
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SiteWithReferenceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Site.class);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public SiteWithReferenceRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public SiteWithReferenceRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }
}
