/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.Custodian;
import com.microsoft.graph.ediscovery.requests.CustodianCollectionPage;
import com.microsoft.graph.ediscovery.requests.CustodianCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.CustodianCollectionResponse;
import com.microsoft.graph.ediscovery.requests.CustodianRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustodianCollectionRequest
extends BaseEntityCollectionRequest<Custodian, CustodianCollectionResponse, CustodianCollectionPage> {
    public CustodianCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CustodianCollectionResponse.class, CustodianCollectionPage.class, CustodianCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Custodian> postAsync(@Nonnull Custodian newCustodian) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CustodianRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newCustodian);
    }

    @Nonnull
    public Custodian post(@Nonnull Custodian newCustodian) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CustodianRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCustodian);
    }

    @Nonnull
    public CustodianCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public CustodianCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

