/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Sharepoint;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SharepointRequest
extends BaseRequest<Sharepoint> {
    public SharepointRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Sharepoint.class);
    }

    @Nonnull
    public CompletableFuture<Sharepoint> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public Sharepoint get() throws ClientException {
        return (Sharepoint)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<Sharepoint> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public Sharepoint delete() throws ClientException {
        return (Sharepoint)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<Sharepoint> patchAsync(@Nonnull Sharepoint sourceSharepoint) {
        return this.sendAsync(HttpMethod.PATCH, sourceSharepoint);
    }

    @Nullable
    public Sharepoint patch(@Nonnull Sharepoint sourceSharepoint) throws ClientException {
        return (Sharepoint)this.send(HttpMethod.PATCH, sourceSharepoint);
    }

    @Nonnull
    public CompletableFuture<Sharepoint> postAsync(@Nonnull Sharepoint newSharepoint) {
        return this.sendAsync(HttpMethod.POST, newSharepoint);
    }

    @Nullable
    public Sharepoint post(@Nonnull Sharepoint newSharepoint) throws ClientException {
        return (Sharepoint)this.send(HttpMethod.POST, newSharepoint);
    }

    @Nonnull
    public CompletableFuture<Sharepoint> putAsync(@Nonnull Sharepoint newSharepoint) {
        return this.sendAsync(HttpMethod.PUT, newSharepoint);
    }

    @Nullable
    public Sharepoint put(@Nonnull Sharepoint newSharepoint) throws ClientException {
        return (Sharepoint)this.send(HttpMethod.PUT, newSharepoint);
    }

    @Nonnull
    public SharepointRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public SharepointRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

