// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AccessReviewExpirationBehavior;
import com.microsoft.graph.models.SubjectSet;
import com.microsoft.graph.models.EntitlementManagementSchedule;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Review Settings.
 */
public class AccessPackageAssignmentReviewSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Expiration Behavior.
     * The default decision to apply if the access is not reviewed. The possible values are: keepAccess, removeAccess, acceptAccessRecommendation, unknownFutureValue.
     */
    @SerializedName(value = "expirationBehavior", alternate = {"ExpirationBehavior"})
    @Expose
	@Nullable
    public AccessReviewExpirationBehavior expirationBehavior;

    /**
     * The Fallback Reviewers.
     * This collection specifies the users who will be the fallback reviewers when the primary reviewers don't respond.
     */
    @SerializedName(value = "fallbackReviewers", alternate = {"FallbackReviewers"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> fallbackReviewers;

    /**
     * The Is Enabled.
     * If true, access reviews are required for assignments through this policy.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Is Recommendation Enabled.
     * Specifies whether to display recommendations to the reviewer. The default value is true.
     */
    @SerializedName(value = "isRecommendationEnabled", alternate = {"IsRecommendationEnabled"})
    @Expose
	@Nullable
    public Boolean isRecommendationEnabled;

    /**
     * The Is Reviewer Justification Required.
     * Specifies whether the reviewer must provide justification for the approval. The default value is true.
     */
    @SerializedName(value = "isReviewerJustificationRequired", alternate = {"IsReviewerJustificationRequired"})
    @Expose
	@Nullable
    public Boolean isReviewerJustificationRequired;

    /**
     * The Is Self Review.
     * Specifies whether the principals can review their own assignments.
     */
    @SerializedName(value = "isSelfReview", alternate = {"IsSelfReview"})
    @Expose
	@Nullable
    public Boolean isSelfReview;

    /**
     * The Primary Reviewers.
     * This collection specifies the users or group of users who will review the access package assignments.
     */
    @SerializedName(value = "primaryReviewers", alternate = {"PrimaryReviewers"})
    @Expose
	@Nullable
    public java.util.List<SubjectSet> primaryReviewers;

    /**
     * The Schedule.
     * When the first review should start and how often it should recur.
     */
    @SerializedName(value = "schedule", alternate = {"Schedule"})
    @Expose
	@Nullable
    public EntitlementManagementSchedule schedule;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
