// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.MobileAppContentFileCommitRequest;
import com.microsoft.graph.models.MobileAppContentFile;
import com.microsoft.graph.models.FileEncryptionInfo;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.MobileAppContentFileCommitParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Content File Commit Request Builder.
 */
public class MobileAppContentFileCommitRequestBuilder extends BaseActionRequestBuilder<MobileAppContentFile> {

    /**
     * The request builder for this MobileAppContentFileCommit
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppContentFileCommitRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private MobileAppContentFileCommitParameterSet body;
    /**
     * The request builder for this MobileAppContentFileCommit
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public MobileAppContentFileCommitRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final MobileAppContentFileCommitParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the MobileAppContentFileCommitRequest
     *
     * @param requestOptions the options for the request
     * @return the MobileAppContentFileCommitRequest instance
     */
    @Nonnull
    public MobileAppContentFileCommitRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the MobileAppContentFileCommitRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the MobileAppContentFileCommitRequest instance
     */
    @Nonnull
    public MobileAppContentFileCommitRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final MobileAppContentFileCommitRequest request = new MobileAppContentFileCommitRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
