// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AccessPackageResourceEnvironment;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AccessPackageResourceRoleCollectionPage;
import com.microsoft.graph.requests.AccessPackageResourceScopeCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Resource.
 */
public class AccessPackageResource extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * 
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * 
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * 
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Modified Date Time.
     * 
     */
    @SerializedName(value = "modifiedDateTime", alternate = {"ModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime modifiedDateTime;

    /**
     * The Origin Id.
     * 
     */
    @SerializedName(value = "originId", alternate = {"OriginId"})
    @Expose
	@Nullable
    public String originId;

    /**
     * The Origin System.
     * 
     */
    @SerializedName(value = "originSystem", alternate = {"OriginSystem"})
    @Expose
	@Nullable
    public String originSystem;

    /**
     * The Environment.
     * 
     */
    @SerializedName(value = "environment", alternate = {"Environment"})
    @Expose
	@Nullable
    public AccessPackageResourceEnvironment environment;

    /**
     * The Roles.
     * 
     */
    @SerializedName(value = "roles", alternate = {"Roles"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AccessPackageResourceRoleCollectionPage roles;

    /**
     * The Scopes.
     * 
     */
    @SerializedName(value = "scopes", alternate = {"Scopes"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AccessPackageResourceScopeCollectionPage scopes;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("roles")) {
            roles = serializer.deserializeObject(json.get("roles"), com.microsoft.graph.requests.AccessPackageResourceRoleCollectionPage.class);
        }

        if (json.has("scopes")) {
            scopes = serializer.deserializeObject(json.get("scopes"), com.microsoft.graph.requests.AccessPackageResourceScopeCollectionPage.class);
        }
    }
}
