// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky Service Principal Confirm Compromised Parameter Set.
 */
public class RiskyServicePrincipalConfirmCompromisedParameterSet {
    /**
     * The service Principal Ids.
     * 
     */
    @SerializedName(value = "servicePrincipalIds", alternate = {"ServicePrincipalIds"})
    @Expose
	@Nullable
    public java.util.List<String> servicePrincipalIds;


    /**
     * Instiaciates a new RiskyServicePrincipalConfirmCompromisedParameterSet
     */
    public RiskyServicePrincipalConfirmCompromisedParameterSet() {}
    /**
     * Instiaciates a new RiskyServicePrincipalConfirmCompromisedParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected RiskyServicePrincipalConfirmCompromisedParameterSet(@Nonnull final RiskyServicePrincipalConfirmCompromisedParameterSetBuilder builder) {
        this.servicePrincipalIds = builder.servicePrincipalIds;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static RiskyServicePrincipalConfirmCompromisedParameterSetBuilder newBuilder() {
        return new RiskyServicePrincipalConfirmCompromisedParameterSetBuilder();
    }
    /**
     * Fluent builder for the RiskyServicePrincipalConfirmCompromisedParameterSet
     */
    public static final class RiskyServicePrincipalConfirmCompromisedParameterSetBuilder {
        /**
         * The servicePrincipalIds parameter value
         */
        @Nullable
        protected java.util.List<String> servicePrincipalIds;
        /**
         * Sets the ServicePrincipalIds
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public RiskyServicePrincipalConfirmCompromisedParameterSetBuilder withServicePrincipalIds(@Nullable final java.util.List<String> val) {
            this.servicePrincipalIds = val;
            return this;
        }
        /**
         * Instanciates a new RiskyServicePrincipalConfirmCompromisedParameterSetBuilder
         */
        @Nullable
        protected RiskyServicePrincipalConfirmCompromisedParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public RiskyServicePrincipalConfirmCompromisedParameterSet build() {
            return new RiskyServicePrincipalConfirmCompromisedParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.servicePrincipalIds != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("servicePrincipalIds", servicePrincipalIds));
        }
        return result;
    }
}
