// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SynchronizationSchedule;
import com.microsoft.graph.models.SynchronizationStatus;
import com.microsoft.graph.models.KeyValuePair;
import com.microsoft.graph.models.SynchronizationSchema;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Job.
 */
public class SynchronizationJob extends Entity implements IJsonBackedObject {


    /**
     * The Schedule.
     * Schedule used to run the job. Read-only.
     */
    @SerializedName(value = "schedule", alternate = {"Schedule"})
    @Expose
	@Nullable
    public SynchronizationSchedule schedule;

    /**
     * The Status.
     * Status of the job, which includes when the job was last run, current job state, and errors.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public SynchronizationStatus status;

    /**
     * The Synchronization Job Settings.
     * Settings associated with the job. Some settings are inherited from the template.
     */
    @SerializedName(value = "synchronizationJobSettings", alternate = {"SynchronizationJobSettings"})
    @Expose
	@Nullable
    public java.util.List<KeyValuePair> synchronizationJobSettings;

    /**
     * The Template Id.
     * Identifier of the synchronization template this job is based on.
     */
    @SerializedName(value = "templateId", alternate = {"TemplateId"})
    @Expose
	@Nullable
    public String templateId;

    /**
     * The Schema.
     * The synchronization schema configured for the job.
     */
    @SerializedName(value = "schema", alternate = {"Schema"})
    @Expose
	@Nullable
    public SynchronizationSchema schema;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
