// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Autopilot Devices Summary.
 */
public class UserExperienceAnalyticsAutopilotDevicesSummary implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Devices Not Autopilot Registered.
     * The count of intune devices that are not autopilot registerd. Read-only.
     */
    @SerializedName(value = "devicesNotAutopilotRegistered", alternate = {"DevicesNotAutopilotRegistered"})
    @Expose
	@Nullable
    public Integer devicesNotAutopilotRegistered;

    /**
     * The Devices Without Autopilot Profile Assigned.
     * The count of intune devices not autopilot profile assigned. Read-only.
     */
    @SerializedName(value = "devicesWithoutAutopilotProfileAssigned", alternate = {"DevicesWithoutAutopilotProfileAssigned"})
    @Expose
	@Nullable
    public Integer devicesWithoutAutopilotProfileAssigned;

    /**
     * The Total Windows10Devices Without Tenant Attached.
     * The count of windows 10 devices that are Intune and co-managed. Read-only.
     */
    @SerializedName(value = "totalWindows10DevicesWithoutTenantAttached", alternate = {"TotalWindows10DevicesWithoutTenantAttached"})
    @Expose
	@Nullable
    public Integer totalWindows10DevicesWithoutTenantAttached;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
