// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.WindowsMalwareCategory;
import com.microsoft.graph.models.WindowsMalwareExecutionState;
import com.microsoft.graph.models.WindowsMalwareSeverity;
import com.microsoft.graph.models.WindowsMalwareState;
import com.microsoft.graph.models.WindowsMalwareThreatState;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Device Malware State.
 */
public class WindowsDeviceMalwareState extends Entity implements IJsonBackedObject {


    /**
     * The Additional Information Url.
     * Information URL to learn more about the malware
     */
    @SerializedName(value = "additionalInformationUrl", alternate = {"AdditionalInformationUrl"})
    @Expose
	@Nullable
    public String additionalInformationUrl;

    /**
     * The Category.
     * Category of the malware. Possible values are: invalid, adware, spyware, passwordStealer, trojanDownloader, worm, backdoor, remoteAccessTrojan, trojan, emailFlooder, keylogger, dialer, monitoringSoftware, browserModifier, cookie, browserPlugin, aolExploit, nuker, securityDisabler, jokeProgram, hostileActiveXControl, softwareBundler, stealthNotifier, settingsModifier, toolBar, remoteControlSoftware, trojanFtp, potentialUnwantedSoftware, icqExploit, trojanTelnet, exploit, filesharingProgram, malwareCreationTool, remote_Control_Software, tool, trojanDenialOfService, trojanDropper, trojanMassMailer, trojanMonitoringSoftware, trojanProxyServer, virus, known, unknown, spp, behavior, vulnerability, policy, enterpriseUnwantedSoftware, ransom, hipsRule.
     */
    @SerializedName(value = "category", alternate = {"Category"})
    @Expose
	@Nullable
    public WindowsMalwareCategory category;

    /**
     * The Detection Count.
     * Number of times the malware is detected
     */
    @SerializedName(value = "detectionCount", alternate = {"DetectionCount"})
    @Expose
	@Nullable
    public Integer detectionCount;

    /**
     * The Display Name.
     * Malware name
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Execution State.
     * Execution status of the malware like blocked/executing etc. Possible values are: unknown, blocked, allowed, running, notRunning.
     */
    @SerializedName(value = "executionState", alternate = {"ExecutionState"})
    @Expose
	@Nullable
    public WindowsMalwareExecutionState executionState;

    /**
     * The Initial Detection Date Time.
     * Initial detection datetime of the malware
     */
    @SerializedName(value = "initialDetectionDateTime", alternate = {"InitialDetectionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime initialDetectionDateTime;

    /**
     * The Last State Change Date Time.
     * The last time this particular threat was changed
     */
    @SerializedName(value = "lastStateChangeDateTime", alternate = {"LastStateChangeDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastStateChangeDateTime;

    /**
     * The Severity.
     * Severity of the malware. Possible values are: unknown, low, moderate, high, severe.
     */
    @SerializedName(value = "severity", alternate = {"Severity"})
    @Expose
	@Nullable
    public WindowsMalwareSeverity severity;

    /**
     * The State.
     * Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: unknown, detected, cleaned, quarantined, removed, allowed, blocked, cleanFailed, quarantineFailed, removeFailed, allowFailed, abandoned, blockFailed.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
	@Nullable
    public WindowsMalwareState state;

    /**
     * The Threat State.
     * Current status of the malware like cleaned/quarantined/allowed etc. Possible values are: active, actionFailed, manualStepsRequired, fullScanRequired, rebootRequired, remediatedWithNonCriticalFailures, quarantined, removed, cleaned, allowed, noStatusCleared.
     */
    @SerializedName(value = "threatState", alternate = {"ThreatState"})
    @Expose
	@Nullable
    public WindowsMalwareThreatState threatState;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
