// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TermsAndConditionsAcceptanceStatus;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Terms And Conditions Acceptance Status Request.
 */
public class TermsAndConditionsAcceptanceStatusRequest extends BaseRequest<TermsAndConditionsAcceptanceStatus> {
	
    /**
     * The request for the TermsAndConditionsAcceptanceStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermsAndConditionsAcceptanceStatusRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TermsAndConditionsAcceptanceStatus.class);
    }

    /**
     * Gets the TermsAndConditionsAcceptanceStatus from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TermsAndConditionsAcceptanceStatus> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TermsAndConditionsAcceptanceStatus from the service
     *
     * @return the TermsAndConditionsAcceptanceStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TermsAndConditionsAcceptanceStatus get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TermsAndConditionsAcceptanceStatus> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TermsAndConditionsAcceptanceStatus delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TermsAndConditionsAcceptanceStatus with a source
     *
     * @param sourceTermsAndConditionsAcceptanceStatus the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TermsAndConditionsAcceptanceStatus> patchAsync(@Nonnull final TermsAndConditionsAcceptanceStatus sourceTermsAndConditionsAcceptanceStatus) {
        return sendAsync(HttpMethod.PATCH, sourceTermsAndConditionsAcceptanceStatus);
    }

    /**
     * Patches this TermsAndConditionsAcceptanceStatus with a source
     *
     * @param sourceTermsAndConditionsAcceptanceStatus the source object with updates
     * @return the updated TermsAndConditionsAcceptanceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TermsAndConditionsAcceptanceStatus patch(@Nonnull final TermsAndConditionsAcceptanceStatus sourceTermsAndConditionsAcceptanceStatus) throws ClientException {
        return send(HttpMethod.PATCH, sourceTermsAndConditionsAcceptanceStatus);
    }

    /**
     * Creates a TermsAndConditionsAcceptanceStatus with a new object
     *
     * @param newTermsAndConditionsAcceptanceStatus the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TermsAndConditionsAcceptanceStatus> postAsync(@Nonnull final TermsAndConditionsAcceptanceStatus newTermsAndConditionsAcceptanceStatus) {
        return sendAsync(HttpMethod.POST, newTermsAndConditionsAcceptanceStatus);
    }

    /**
     * Creates a TermsAndConditionsAcceptanceStatus with a new object
     *
     * @param newTermsAndConditionsAcceptanceStatus the new object to create
     * @return the created TermsAndConditionsAcceptanceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TermsAndConditionsAcceptanceStatus post(@Nonnull final TermsAndConditionsAcceptanceStatus newTermsAndConditionsAcceptanceStatus) throws ClientException {
        return send(HttpMethod.POST, newTermsAndConditionsAcceptanceStatus);
    }

    /**
     * Creates a TermsAndConditionsAcceptanceStatus with a new object
     *
     * @param newTermsAndConditionsAcceptanceStatus the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TermsAndConditionsAcceptanceStatus> putAsync(@Nonnull final TermsAndConditionsAcceptanceStatus newTermsAndConditionsAcceptanceStatus) {
        return sendAsync(HttpMethod.PUT, newTermsAndConditionsAcceptanceStatus);
    }

    /**
     * Creates a TermsAndConditionsAcceptanceStatus with a new object
     *
     * @param newTermsAndConditionsAcceptanceStatus the object to create/update
     * @return the created TermsAndConditionsAcceptanceStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TermsAndConditionsAcceptanceStatus put(@Nonnull final TermsAndConditionsAcceptanceStatus newTermsAndConditionsAcceptanceStatus) throws ClientException {
        return send(HttpMethod.PUT, newTermsAndConditionsAcceptanceStatus);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TermsAndConditionsAcceptanceStatusRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TermsAndConditionsAcceptanceStatusRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

