/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.requests.HostCollectionPage;
import com.microsoft.graph.security.requests.HostCollectionRequestBuilder;
import com.microsoft.graph.security.requests.HostCollectionResponse;
import com.microsoft.graph.security.requests.HostRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostCollectionRequest
extends BaseEntityCollectionRequest<Host, HostCollectionResponse, HostCollectionPage> {
    public HostCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostCollectionResponse.class, HostCollectionPage.class, HostCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Host> postAsync(@Nonnull Host newHost) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newHost);
    }

    @Nonnull
    public Host post(@Nonnull Host newHost) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new HostRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newHost);
    }

    @Nonnull
    public HostCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public HostCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public HostCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

