/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.ediscovery.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.ediscovery.models.Case;
import com.microsoft.graph.ediscovery.requests.CaseCollectionPage;
import com.microsoft.graph.ediscovery.requests.CaseCollectionRequestBuilder;
import com.microsoft.graph.ediscovery.requests.CaseCollectionResponse;
import com.microsoft.graph.ediscovery.requests.CaseRequestBuilder;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CaseCollectionRequest
extends BaseEntityCollectionRequest<Case, CaseCollectionResponse, CaseCollectionPage> {
    public CaseCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CaseCollectionResponse.class, CaseCollectionPage.class, CaseCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Case> postAsync(@Nonnull Case newCase) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CaseRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newCase);
    }

    @Nonnull
    public Case post(@Nonnull Case newCase) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CaseRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCase);
    }

    @Nonnull
    public CaseCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public CaseCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

