// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.identitygovernance.models.UserProcessingResult;
import com.microsoft.graph.identitygovernance.models.UserSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionWithReferencesPage;
import com.microsoft.graph.identitygovernance.requests.UserProcessingResultCollectionResponse;
import com.microsoft.graph.identitygovernance.models.UserProcessingResult;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Processing Result Collection With References Page.
 */
public class UserProcessingResultCollectionWithReferencesPage extends BaseCollectionPage<UserProcessingResult, UserProcessingResultCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for UserProcessingResult
     *
     * @param response the serialized UserProcessingResultCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public UserProcessingResultCollectionWithReferencesPage(@Nonnull final UserProcessingResultCollectionResponse response, @Nullable final UserProcessingResultCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for UserProcessingResult
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public UserProcessingResultCollectionWithReferencesPage(@Nonnull final java.util.List<UserProcessingResult> pageContents, @Nullable final UserProcessingResultCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
