// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.Run;
import com.microsoft.graph.identitygovernance.models.RunSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Run Request.
 */
public class RunRequest extends BaseRequest<Run> {
	
    /**
     * The request for the Run
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RunRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Run.class);
    }

    /**
     * Gets the Run from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Run> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Run from the service
     *
     * @return the Run from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Run get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Run> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Run delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Run with a source
     *
     * @param sourceRun the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Run> patchAsync(@Nonnull final Run sourceRun) {
        return sendAsync(HttpMethod.PATCH, sourceRun);
    }

    /**
     * Patches this Run with a source
     *
     * @param sourceRun the source object with updates
     * @return the updated Run
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Run patch(@Nonnull final Run sourceRun) throws ClientException {
        return send(HttpMethod.PATCH, sourceRun);
    }

    /**
     * Creates a Run with a new object
     *
     * @param newRun the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Run> postAsync(@Nonnull final Run newRun) {
        return sendAsync(HttpMethod.POST, newRun);
    }

    /**
     * Creates a Run with a new object
     *
     * @param newRun the new object to create
     * @return the created Run
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Run post(@Nonnull final Run newRun) throws ClientException {
        return send(HttpMethod.POST, newRun);
    }

    /**
     * Creates a Run with a new object
     *
     * @param newRun the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Run> putAsync(@Nonnull final Run newRun) {
        return sendAsync(HttpMethod.PUT, newRun);
    }

    /**
     * Creates a Run with a new object
     *
     * @param newRun the object to create/update
     * @return the created Run
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Run put(@Nonnull final Run newRun) throws ClientException {
        return send(HttpMethod.PUT, newRun);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RunRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RunRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

