// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.TenantInformation;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Tenant Relationship Find Tenant Information By Tenant Id Parameter Set.
 */
public class TenantRelationshipFindTenantInformationByTenantIdParameterSet {
    /**
     * The tenant Id.
     * 
     */
    @SerializedName(value = "tenantId", alternate = {"TenantId"})
    @Expose
	@Nullable
    public String tenantId;


    /**
     * Instiaciates a new TenantRelationshipFindTenantInformationByTenantIdParameterSet
     */
    public TenantRelationshipFindTenantInformationByTenantIdParameterSet() {}
    /**
     * Instiaciates a new TenantRelationshipFindTenantInformationByTenantIdParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected TenantRelationshipFindTenantInformationByTenantIdParameterSet(@Nonnull final TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder builder) {
        this.tenantId = builder.tenantId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder newBuilder() {
        return new TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder();
    }
    /**
     * Fluent builder for the TenantRelationshipFindTenantInformationByTenantIdParameterSet
     */
    public static final class TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder {
        /**
         * The tenantId parameter value
         */
        @Nullable
        protected String tenantId;
        /**
         * Sets the TenantId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder withTenantId(@Nullable final String val) {
            this.tenantId = val;
            return this;
        }
        /**
         * Instanciates a new TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder
         */
        @Nullable
        protected TenantRelationshipFindTenantInformationByTenantIdParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public TenantRelationshipFindTenantInformationByTenantIdParameterSet build() {
            return new TenantRelationshipFindTenantInformationByTenantIdParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.tenantId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("tenantId", tenantId));
        }
        return result;
    }
}
