// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DirectoryDefinition;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Definition Request.
 */
public class DirectoryDefinitionRequest extends BaseRequest<DirectoryDefinition> {
	
    /**
     * The request for the DirectoryDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DirectoryDefinitionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryDefinition.class);
    }

    /**
     * Gets the DirectoryDefinition from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryDefinition> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DirectoryDefinition from the service
     *
     * @return the DirectoryDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryDefinition get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryDefinition> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DirectoryDefinition delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DirectoryDefinition with a source
     *
     * @param sourceDirectoryDefinition the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryDefinition> patchAsync(@Nonnull final DirectoryDefinition sourceDirectoryDefinition) {
        return sendAsync(HttpMethod.PATCH, sourceDirectoryDefinition);
    }

    /**
     * Patches this DirectoryDefinition with a source
     *
     * @param sourceDirectoryDefinition the source object with updates
     * @return the updated DirectoryDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryDefinition patch(@Nonnull final DirectoryDefinition sourceDirectoryDefinition) throws ClientException {
        return send(HttpMethod.PATCH, sourceDirectoryDefinition);
    }

    /**
     * Creates a DirectoryDefinition with a new object
     *
     * @param newDirectoryDefinition the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryDefinition> postAsync(@Nonnull final DirectoryDefinition newDirectoryDefinition) {
        return sendAsync(HttpMethod.POST, newDirectoryDefinition);
    }

    /**
     * Creates a DirectoryDefinition with a new object
     *
     * @param newDirectoryDefinition the new object to create
     * @return the created DirectoryDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryDefinition post(@Nonnull final DirectoryDefinition newDirectoryDefinition) throws ClientException {
        return send(HttpMethod.POST, newDirectoryDefinition);
    }

    /**
     * Creates a DirectoryDefinition with a new object
     *
     * @param newDirectoryDefinition the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DirectoryDefinition> putAsync(@Nonnull final DirectoryDefinition newDirectoryDefinition) {
        return sendAsync(HttpMethod.PUT, newDirectoryDefinition);
    }

    /**
     * Creates a DirectoryDefinition with a new object
     *
     * @param newDirectoryDefinition the object to create/update
     * @return the created DirectoryDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DirectoryDefinition put(@Nonnull final DirectoryDefinition newDirectoryDefinition) throws ClientException {
        return send(HttpMethod.PUT, newDirectoryDefinition);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DirectoryDefinitionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DirectoryDefinitionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

