// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.LifecycleWorkflowsContainer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Lifecycle Workflows Container Request Builder.
 */
public class LifecycleWorkflowsContainerRequestBuilder extends BaseRequestBuilder<LifecycleWorkflowsContainer> {

    /**
     * The request builder for the LifecycleWorkflowsContainer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LifecycleWorkflowsContainerRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the LifecycleWorkflowsContainerRequest instance
     */
    @Nonnull
    public LifecycleWorkflowsContainerRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the LifecycleWorkflowsContainerRequest instance
     */
    @Nonnull
    public LifecycleWorkflowsContainerRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.identitygovernance.requests.LifecycleWorkflowsContainerRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the CustomTaskExtension collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionRequestBuilder customTaskExtensions() {
        return new com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("customTaskExtensions"), getClient(), null);
    }

    /**
     * Gets a request builder for the CustomTaskExtension item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionRequestBuilder customTaskExtensions(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.CustomTaskExtensionRequestBuilder(getRequestUrlWithAdditionalSegment("customTaskExtensions") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for DeletedItemContainer
     *
     * @return the DeletedItemContainerRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.DeletedItemContainerRequestBuilder deletedItems() {
        return new com.microsoft.graph.requests.DeletedItemContainerRequestBuilder(getRequestUrlWithAdditionalSegment("deletedItems"), getClient(), null);
    }

    /**
     * Gets the request builder for LifecycleManagementSettings
     *
     * @return the LifecycleManagementSettingsRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.LifecycleManagementSettingsRequestBuilder settings() {
        return new com.microsoft.graph.identitygovernance.requests.LifecycleManagementSettingsRequestBuilder(getRequestUrlWithAdditionalSegment("settings"), getClient(), null);
    }
    /**
     *  Gets a request builder for the TaskDefinition collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionRequestBuilder taskDefinitions() {
        return new com.microsoft.graph.identitygovernance.requests.TaskDefinitionCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinitions"), getClient(), null);
    }

    /**
     * Gets a request builder for the TaskDefinition item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.TaskDefinitionRequestBuilder taskDefinitions(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.TaskDefinitionRequestBuilder(getRequestUrlWithAdditionalSegment("taskDefinitions") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Workflow collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.WorkflowCollectionRequestBuilder workflows() {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("workflows"), getClient(), null);
    }

    /**
     * Gets a request builder for the Workflow item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.WorkflowRequestBuilder workflows(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowRequestBuilder(getRequestUrlWithAdditionalSegment("workflows") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the WorkflowTemplate collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionRequestBuilder workflowTemplates() {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowTemplateCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("workflowTemplates"), getClient(), null);
    }

    /**
     * Gets a request builder for the WorkflowTemplate item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.identitygovernance.requests.WorkflowTemplateRequestBuilder workflowTemplates(@Nonnull final String id) {
        return new com.microsoft.graph.identitygovernance.requests.WorkflowTemplateRequestBuilder(getRequestUrlWithAdditionalSegment("workflowTemplates") + "/" + id, getClient(), null);
    }
}
