// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;
import com.microsoft.graph.identitygovernance.requests.TaskProcessingResultResumeRequest;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResult;
import com.microsoft.graph.identitygovernance.models.CustomTaskExtensionCallbackData;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.identitygovernance.models.TaskProcessingResultResumeParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Processing Result Resume Request Builder.
 */
public class TaskProcessingResultResumeRequestBuilder extends BaseActionRequestBuilder<TaskProcessingResult> {

    /**
     * The request builder for this TaskProcessingResultResume
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TaskProcessingResultResumeRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private TaskProcessingResultResumeParameterSet body;
    /**
     * The request builder for this TaskProcessingResultResume
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public TaskProcessingResultResumeRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final TaskProcessingResultResumeParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the TaskProcessingResultResumeRequest
     *
     * @param requestOptions the options for the request
     * @return the TaskProcessingResultResumeRequest instance
     */
    @Nonnull
    public TaskProcessingResultResumeRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the TaskProcessingResultResumeRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the TaskProcessingResultResumeRequest instance
     */
    @Nonnull
    public TaskProcessingResultResumeRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final TaskProcessingResultResumeRequest request = new TaskProcessingResultResumeRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
