// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.TaskReport;
import com.microsoft.graph.identitygovernance.models.TaskReportSummary;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Report Request.
 */
public class TaskReportRequest extends BaseRequest<TaskReport> {
	
    /**
     * The request for the TaskReport
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TaskReportRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TaskReport.class);
    }

    /**
     * Gets the TaskReport from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskReport> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TaskReport from the service
     *
     * @return the TaskReport from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskReport get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskReport> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TaskReport delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TaskReport with a source
     *
     * @param sourceTaskReport the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskReport> patchAsync(@Nonnull final TaskReport sourceTaskReport) {
        return sendAsync(HttpMethod.PATCH, sourceTaskReport);
    }

    /**
     * Patches this TaskReport with a source
     *
     * @param sourceTaskReport the source object with updates
     * @return the updated TaskReport
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskReport patch(@Nonnull final TaskReport sourceTaskReport) throws ClientException {
        return send(HttpMethod.PATCH, sourceTaskReport);
    }

    /**
     * Creates a TaskReport with a new object
     *
     * @param newTaskReport the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskReport> postAsync(@Nonnull final TaskReport newTaskReport) {
        return sendAsync(HttpMethod.POST, newTaskReport);
    }

    /**
     * Creates a TaskReport with a new object
     *
     * @param newTaskReport the new object to create
     * @return the created TaskReport
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskReport post(@Nonnull final TaskReport newTaskReport) throws ClientException {
        return send(HttpMethod.POST, newTaskReport);
    }

    /**
     * Creates a TaskReport with a new object
     *
     * @param newTaskReport the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TaskReport> putAsync(@Nonnull final TaskReport newTaskReport) {
        return sendAsync(HttpMethod.PUT, newTaskReport);
    }

    /**
     * Creates a TaskReport with a new object
     *
     * @param newTaskReport the object to create/update
     * @return the created TaskReport
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TaskReport put(@Nonnull final TaskReport newTaskReport) throws ClientException {
        return send(HttpMethod.PUT, newTaskReport);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TaskReportRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TaskReportRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

