// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.identitygovernance.models.Task;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Task Request.
 */
public class TaskRequest extends BaseRequest<Task> {
	
    /**
     * The request for the Task
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TaskRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Task.class);
    }

    /**
     * Gets the Task from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Task> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Task from the service
     *
     * @return the Task from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Task get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Task> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Task delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Task with a source
     *
     * @param sourceTask the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Task> patchAsync(@Nonnull final Task sourceTask) {
        return sendAsync(HttpMethod.PATCH, sourceTask);
    }

    /**
     * Patches this Task with a source
     *
     * @param sourceTask the source object with updates
     * @return the updated Task
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Task patch(@Nonnull final Task sourceTask) throws ClientException {
        return send(HttpMethod.PATCH, sourceTask);
    }

    /**
     * Creates a Task with a new object
     *
     * @param newTask the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Task> postAsync(@Nonnull final Task newTask) {
        return sendAsync(HttpMethod.POST, newTask);
    }

    /**
     * Creates a Task with a new object
     *
     * @param newTask the new object to create
     * @return the created Task
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Task post(@Nonnull final Task newTask) throws ClientException {
        return send(HttpMethod.POST, newTask);
    }

    /**
     * Creates a Task with a new object
     *
     * @param newTask the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Task> putAsync(@Nonnull final Task newTask) {
        return sendAsync(HttpMethod.PUT, newTask);
    }

    /**
     * Creates a Task with a new object
     *
     * @param newTask the object to create/update
     * @return the created Task
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Task put(@Nonnull final Task newTask) throws ClientException {
        return send(HttpMethod.PUT, newTask);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TaskRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TaskRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

