// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Protection Overview.
 */
public class DeviceProtectionOverview implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Clean Device Count.
     * Indicates number of devices reporting as clean
     */
    @SerializedName(value = "cleanDeviceCount", alternate = {"CleanDeviceCount"})
    @Expose
	@Nullable
    public Integer cleanDeviceCount;

    /**
     * The Critical Failures Device Count.
     * Indicates number of devices with critical failures
     */
    @SerializedName(value = "criticalFailuresDeviceCount", alternate = {"CriticalFailuresDeviceCount"})
    @Expose
	@Nullable
    public Integer criticalFailuresDeviceCount;

    /**
     * The Inactive Threat Agent Device Count.
     * Indicates number of devices with inactive threat agent
     */
    @SerializedName(value = "inactiveThreatAgentDeviceCount", alternate = {"InactiveThreatAgentDeviceCount"})
    @Expose
	@Nullable
    public Integer inactiveThreatAgentDeviceCount;

    /**
     * The Pending Full Scan Device Count.
     * Indicates number of devices pending full scan
     */
    @SerializedName(value = "pendingFullScanDeviceCount", alternate = {"PendingFullScanDeviceCount"})
    @Expose
	@Nullable
    public Integer pendingFullScanDeviceCount;

    /**
     * The Pending Manual Steps Device Count.
     * Indicates number of devices with pending manual steps
     */
    @SerializedName(value = "pendingManualStepsDeviceCount", alternate = {"PendingManualStepsDeviceCount"})
    @Expose
	@Nullable
    public Integer pendingManualStepsDeviceCount;

    /**
     * The Pending Offline Scan Device Count.
     * Indicates number of pending offline scan devices
     */
    @SerializedName(value = "pendingOfflineScanDeviceCount", alternate = {"PendingOfflineScanDeviceCount"})
    @Expose
	@Nullable
    public Integer pendingOfflineScanDeviceCount;

    /**
     * The Pending Quick Scan Device Count.
     * Indicates the number of devices that have a pending full scan. Valid values -2147483648 to 2147483647
     */
    @SerializedName(value = "pendingQuickScanDeviceCount", alternate = {"PendingQuickScanDeviceCount"})
    @Expose
	@Nullable
    public Integer pendingQuickScanDeviceCount;

    /**
     * The Pending Restart Device Count.
     * Indicates number of devices pending restart
     */
    @SerializedName(value = "pendingRestartDeviceCount", alternate = {"PendingRestartDeviceCount"})
    @Expose
	@Nullable
    public Integer pendingRestartDeviceCount;

    /**
     * The Pending Signature Update Device Count.
     * Indicates number of devices with an old signature
     */
    @SerializedName(value = "pendingSignatureUpdateDeviceCount", alternate = {"PendingSignatureUpdateDeviceCount"})
    @Expose
	@Nullable
    public Integer pendingSignatureUpdateDeviceCount;

    /**
     * The Total Reported Device Count.
     * Total device count.
     */
    @SerializedName(value = "totalReportedDeviceCount", alternate = {"TotalReportedDeviceCount"})
    @Expose
	@Nullable
    public Integer totalReportedDeviceCount;

    /**
     * The Unknown State Threat Agent Device Count.
     * Indicates number of devices with threat agent state as unknown
     */
    @SerializedName(value = "unknownStateThreatAgentDeviceCount", alternate = {"UnknownStateThreatAgentDeviceCount"})
    @Expose
	@Nullable
    public Integer unknownStateThreatAgentDeviceCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
