// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ScheduleRequestActions;
import com.microsoft.graph.models.RequestSchedule;
import com.microsoft.graph.models.TicketInfo;
import com.microsoft.graph.models.Request;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Privileged Access Schedule Request.
 */
public class PrivilegedAccessScheduleRequest extends Request implements IJsonBackedObject {


    /**
     * The Action.
     * 
     */
    @SerializedName(value = "action", alternate = {"Action"})
    @Expose
	@Nullable
    public ScheduleRequestActions action;

    /**
     * The Is Validation Only.
     * 
     */
    @SerializedName(value = "isValidationOnly", alternate = {"IsValidationOnly"})
    @Expose
	@Nullable
    public Boolean isValidationOnly;

    /**
     * The Justification.
     * 
     */
    @SerializedName(value = "justification", alternate = {"Justification"})
    @Expose
	@Nullable
    public String justification;

    /**
     * The Schedule Info.
     * 
     */
    @SerializedName(value = "scheduleInfo", alternate = {"ScheduleInfo"})
    @Expose
	@Nullable
    public RequestSchedule scheduleInfo;

    /**
     * The Ticket Info.
     * 
     */
    @SerializedName(value = "ticketInfo", alternate = {"TicketInfo"})
    @Expose
	@Nullable
    public TicketInfo ticketInfo;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
