// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Training Content Event Info.
 */
public class UserTrainingContentEventInfo implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Browser.
     * Browser of the user from where the training event was generated.
     */
    @SerializedName(value = "browser", alternate = {"Browser"})
    @Expose
	@Nullable
    public String browser;

    /**
     * The Content Date Time.
     * Date and time of the training content playback by the user.
     */
    @SerializedName(value = "contentDateTime", alternate = {"ContentDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime contentDateTime;

    /**
     * The Ip Address.
     * IP address of the user for the training event.
     */
    @SerializedName(value = "ipAddress", alternate = {"IpAddress"})
    @Expose
	@Nullable
    public String ipAddress;

    /**
     * The Os Platform Device Details.
     * The operating system, platform, and device details of the user for the training event.
     */
    @SerializedName(value = "osPlatformDeviceDetails", alternate = {"OsPlatformDeviceDetails"})
    @Expose
	@Nullable
    public String osPlatformDeviceDetails;

    /**
     * The Potential Score Impact.
     * Potential improvement in the tenant security posture after completion of the training by the user.
     */
    @SerializedName(value = "potentialScoreImpact", alternate = {"PotentialScoreImpact"})
    @Expose
	@Nullable
    public Double potentialScoreImpact;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
