// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DocumentSet;
import com.microsoft.graph.models.ColumnDefinition;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionCollectionWithReferencesPage;
import com.microsoft.graph.requests.ColumnDefinitionCollectionResponse;
import com.microsoft.graph.models.ColumnDefinition;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Column Definition Collection With References Page.
 */
public class ColumnDefinitionCollectionWithReferencesPage extends BaseCollectionPage<ColumnDefinition, ColumnDefinitionCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for ColumnDefinition
     *
     * @param response the serialized ColumnDefinitionCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public ColumnDefinitionCollectionWithReferencesPage(@Nonnull final ColumnDefinitionCollectionResponse response, @Nullable final ColumnDefinitionCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for ColumnDefinition
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public ColumnDefinitionCollectionWithReferencesPage(@Nonnull final java.util.List<ColumnDefinition> pageContents, @Nullable final ColumnDefinitionCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
