// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.HostSslCertificate;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Ssl Certificate Request.
 */
public class HostSslCertificateRequest extends BaseRequest<HostSslCertificate> {
	
    /**
     * The request for the HostSslCertificate
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public HostSslCertificateRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostSslCertificate.class);
    }

    /**
     * Gets the HostSslCertificate from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostSslCertificate> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the HostSslCertificate from the service
     *
     * @return the HostSslCertificate from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostSslCertificate get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostSslCertificate> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public HostSslCertificate delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this HostSslCertificate with a source
     *
     * @param sourceHostSslCertificate the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostSslCertificate> patchAsync(@Nonnull final HostSslCertificate sourceHostSslCertificate) {
        return sendAsync(HttpMethod.PATCH, sourceHostSslCertificate);
    }

    /**
     * Patches this HostSslCertificate with a source
     *
     * @param sourceHostSslCertificate the source object with updates
     * @return the updated HostSslCertificate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostSslCertificate patch(@Nonnull final HostSslCertificate sourceHostSslCertificate) throws ClientException {
        return send(HttpMethod.PATCH, sourceHostSslCertificate);
    }

    /**
     * Creates a HostSslCertificate with a new object
     *
     * @param newHostSslCertificate the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostSslCertificate> postAsync(@Nonnull final HostSslCertificate newHostSslCertificate) {
        return sendAsync(HttpMethod.POST, newHostSslCertificate);
    }

    /**
     * Creates a HostSslCertificate with a new object
     *
     * @param newHostSslCertificate the new object to create
     * @return the created HostSslCertificate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostSslCertificate post(@Nonnull final HostSslCertificate newHostSslCertificate) throws ClientException {
        return send(HttpMethod.POST, newHostSslCertificate);
    }

    /**
     * Creates a HostSslCertificate with a new object
     *
     * @param newHostSslCertificate the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<HostSslCertificate> putAsync(@Nonnull final HostSslCertificate newHostSslCertificate) {
        return sendAsync(HttpMethod.PUT, newHostSslCertificate);
    }

    /**
     * Creates a HostSslCertificate with a new object
     *
     * @param newHostSslCertificate the object to create/update
     * @return the created HostSslCertificate
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public HostSslCertificate put(@Nonnull final HostSslCertificate newHostSslCertificate) throws ClientException {
        return send(HttpMethod.PUT, newHostSslCertificate);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public HostSslCertificateRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public HostSslCertificateRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

