// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.IpAddress;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ip Address Request Builder.
 */
public class IpAddressRequestBuilder extends BaseRequestBuilder<IpAddress> {

    /**
     * The request builder for the IpAddress
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IpAddressRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IpAddressRequest instance
     */
    @Nonnull
    public IpAddressRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IpAddressRequest instance
     */
    @Nonnull
    public IpAddressRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.security.requests.IpAddressRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the HostPair collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder childHostPairs() {
        return new com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("childHostPairs"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostPair item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairWithReferenceRequestBuilder childHostPairs(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostPairWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("childHostPairs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostComponent collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostComponentCollectionWithReferencesRequestBuilder components() {
        return new com.microsoft.graph.security.requests.HostComponentCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("components"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostComponent item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostComponentWithReferenceRequestBuilder components(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostComponentWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("components") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostCookie collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostCookieCollectionWithReferencesRequestBuilder cookies() {
        return new com.microsoft.graph.security.requests.HostCookieCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("cookies"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostCookie item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostCookieWithReferenceRequestBuilder cookies(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostCookieWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("cookies") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostPair collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder hostPairs() {
        return new com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("hostPairs"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostPair item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairWithReferenceRequestBuilder hostPairs(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostPairWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("hostPairs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostPair collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder parentHostPairs() {
        return new com.microsoft.graph.security.requests.HostPairCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("parentHostPairs"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostPair item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostPairWithReferenceRequestBuilder parentHostPairs(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostPairWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("parentHostPairs") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PassiveDnsRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesRequestBuilder passiveDns() {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("passiveDns"), getClient(), null);
    }

    /**
     * Gets a request builder for the PassiveDnsRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.PassiveDnsRecordWithReferenceRequestBuilder passiveDns(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("passiveDns") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the PassiveDnsRecord collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesRequestBuilder passiveDnsReverse() {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("passiveDnsReverse"), getClient(), null);
    }

    /**
     * Gets a request builder for the PassiveDnsRecord item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.PassiveDnsRecordWithReferenceRequestBuilder passiveDnsReverse(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.PassiveDnsRecordWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("passiveDnsReverse") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for HostReputation
     *
     * @return the HostReputationRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostReputationRequestBuilder reputation() {
        return new com.microsoft.graph.security.requests.HostReputationRequestBuilder(getRequestUrlWithAdditionalSegment("reputation"), getClient(), null);
    }
    /**
     *  Gets a request builder for the HostSslCertificate collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostSslCertificateCollectionWithReferencesRequestBuilder sslCertificates() {
        return new com.microsoft.graph.security.requests.HostSslCertificateCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("sslCertificates"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostSslCertificate item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostSslCertificateWithReferenceRequestBuilder sslCertificates(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostSslCertificateWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("sslCertificates") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Subdomain collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.SubdomainCollectionWithReferencesRequestBuilder subdomains() {
        return new com.microsoft.graph.security.requests.SubdomainCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("subdomains"), getClient(), null);
    }

    /**
     * Gets a request builder for the Subdomain item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.SubdomainWithReferenceRequestBuilder subdomains(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.SubdomainWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("subdomains") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the HostTracker collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostTrackerCollectionWithReferencesRequestBuilder trackers() {
        return new com.microsoft.graph.security.requests.HostTrackerCollectionWithReferencesRequestBuilder(getRequestUrlWithAdditionalSegment("trackers"), getClient(), null);
    }

    /**
     * Gets a request builder for the HostTracker item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.security.requests.HostTrackerWithReferenceRequestBuilder trackers(@Nonnull final String id) {
        return new com.microsoft.graph.security.requests.HostTrackerWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("trackers") + "/" + id, getClient(), null);
    }

    /**
     * Gets the request builder for WhoisRecord
     *
     * @return the WhoisRecordWithReferenceRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.security.requests.WhoisRecordWithReferenceRequestBuilder whois() {
        return new com.microsoft.graph.security.requests.WhoisRecordWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("whois"), getClient(), null);
    }
}
