/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.DriveItem;
import com.microsoft.graph.models.DriveItemAssignSensitivityLabelParameterSet;
import com.microsoft.graph.models.DriveItemCheckinParameterSet;
import com.microsoft.graph.models.DriveItemCopyParameterSet;
import com.microsoft.graph.models.DriveItemCreateLinkParameterSet;
import com.microsoft.graph.models.DriveItemCreateUploadSessionParameterSet;
import com.microsoft.graph.models.DriveItemDeltaParameterSet;
import com.microsoft.graph.models.DriveItemGetActivitiesByIntervalParameterSet;
import com.microsoft.graph.models.DriveItemInviteParameterSet;
import com.microsoft.graph.models.DriveItemPreviewParameterSet;
import com.microsoft.graph.models.DriveItemRestoreParameterSet;
import com.microsoft.graph.models.DriveItemSearchParameterSet;
import com.microsoft.graph.models.DriveItemValidatePermissionParameterSet;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DriveItemAssignSensitivityLabelRequestBuilder;
import com.microsoft.graph.requests.DriveItemCheckinRequestBuilder;
import com.microsoft.graph.requests.DriveItemCheckoutRequestBuilder;
import com.microsoft.graph.requests.DriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemContentStreamRequestBuilder;
import com.microsoft.graph.requests.DriveItemCopyRequestBuilder;
import com.microsoft.graph.requests.DriveItemCreateLinkRequestBuilder;
import com.microsoft.graph.requests.DriveItemCreateUploadSessionRequestBuilder;
import com.microsoft.graph.requests.DriveItemDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemExtractSensitivityLabelsRequestBuilder;
import com.microsoft.graph.requests.DriveItemFollowRequestBuilder;
import com.microsoft.graph.requests.DriveItemGetActivitiesByIntervalCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemInviteCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemPermanentDeleteRequestBuilder;
import com.microsoft.graph.requests.DriveItemPreviewRequestBuilder;
import com.microsoft.graph.requests.DriveItemRequest;
import com.microsoft.graph.requests.DriveItemRestoreRequestBuilder;
import com.microsoft.graph.requests.DriveItemSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemUnfollowRequestBuilder;
import com.microsoft.graph.requests.DriveItemValidatePermissionRequestBuilder;
import com.microsoft.graph.requests.DriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.DriveItemVersionRequestBuilder;
import com.microsoft.graph.requests.ItemAnalyticsRequestBuilder;
import com.microsoft.graph.requests.ListItemRequestBuilder;
import com.microsoft.graph.requests.PermissionCollectionRequestBuilder;
import com.microsoft.graph.requests.PermissionRequestBuilder;
import com.microsoft.graph.requests.SubscriptionCollectionRequestBuilder;
import com.microsoft.graph.requests.SubscriptionRequestBuilder;
import com.microsoft.graph.requests.ThumbnailSetCollectionRequestBuilder;
import com.microsoft.graph.requests.ThumbnailSetRequestBuilder;
import com.microsoft.graph.requests.UserWithReferenceRequestBuilder;
import com.microsoft.graph.requests.WorkbookRequestBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DriveItemRequestBuilder
extends BaseRequestBuilder<DriveItem> {
    public DriveItemRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public DriveItemRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public DriveItemRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new DriveItemRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public DriveItemRequestBuilder itemWithPath(@Nonnull String path) {
        String value = path;
        try {
            value = URLEncoder.encode(path, StandardCharsets.UTF_8.toString()).replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ClientException("unsupported encoding", (Throwable)ex);
        }
        return new DriveItemRequestBuilder(this.getRequestUrl() + ":/" + value + ":", this.getClient(), null);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder createdByUser() {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("createdByUser"), this.getClient(), null);
    }

    @Nonnull
    public UserWithReferenceRequestBuilder lastModifiedByUser() {
        return new UserWithReferenceRequestBuilder(this.getRequestUrlWithAdditionalSegment("lastModifiedByUser"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookRequestBuilder workbook() {
        return new WorkbookRequestBuilder(this.getRequestUrlWithAdditionalSegment("workbook"), this.getClient(), null);
    }

    @Nonnull
    public ItemAnalyticsRequestBuilder analytics() {
        return new ItemAnalyticsRequestBuilder(this.getRequestUrlWithAdditionalSegment("analytics"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemCollectionRequestBuilder children() {
        return new DriveItemCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("children"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRequestBuilder children(@Nonnull String id) {
        return new DriveItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("children") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ListItemRequestBuilder listItem() {
        return new ListItemRequestBuilder(this.getRequestUrlWithAdditionalSegment("listItem"), this.getClient(), null);
    }

    @Nonnull
    public PermissionCollectionRequestBuilder permissions() {
        return new PermissionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("permissions"), this.getClient(), null);
    }

    @Nonnull
    public PermissionRequestBuilder permissions(@Nonnull String id) {
        return new PermissionRequestBuilder(this.getRequestUrlWithAdditionalSegment("permissions") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public SubscriptionCollectionRequestBuilder subscriptions() {
        return new SubscriptionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("subscriptions"), this.getClient(), null);
    }

    @Nonnull
    public SubscriptionRequestBuilder subscriptions(@Nonnull String id) {
        return new SubscriptionRequestBuilder(this.getRequestUrlWithAdditionalSegment("subscriptions") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public ThumbnailSetCollectionRequestBuilder thumbnails() {
        return new ThumbnailSetCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("thumbnails"), this.getClient(), null);
    }

    @Nonnull
    public ThumbnailSetRequestBuilder thumbnails(@Nonnull String id) {
        return new ThumbnailSetRequestBuilder(this.getRequestUrlWithAdditionalSegment("thumbnails") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DriveItemVersionCollectionRequestBuilder versions() {
        return new DriveItemVersionCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("versions"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemVersionRequestBuilder versions(@Nonnull String id) {
        return new DriveItemVersionRequestBuilder(this.getRequestUrlWithAdditionalSegment("versions") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DriveItemContentStreamRequestBuilder content() {
        return new DriveItemContentStreamRequestBuilder(this.getRequestUrlWithAdditionalSegment("content"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemRestoreRequestBuilder restore(@Nonnull DriveItemRestoreParameterSet parameters) {
        return new DriveItemRestoreRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.restore"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemCopyRequestBuilder copy(@Nonnull DriveItemCopyParameterSet parameters) {
        return new DriveItemCopyRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.copy"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemCreateUploadSessionRequestBuilder createUploadSession(@Nonnull DriveItemCreateUploadSessionParameterSet parameters) {
        return new DriveItemCreateUploadSessionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.createUploadSession"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemAssignSensitivityLabelRequestBuilder assignSensitivityLabel(@Nonnull DriveItemAssignSensitivityLabelParameterSet parameters) {
        return new DriveItemAssignSensitivityLabelRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.assignSensitivityLabel"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemCheckinRequestBuilder checkin(@Nonnull DriveItemCheckinParameterSet parameters) {
        return new DriveItemCheckinRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.checkin"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemCheckoutRequestBuilder checkout() {
        return new DriveItemCheckoutRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.checkout"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemCreateLinkRequestBuilder createLink(@Nonnull DriveItemCreateLinkParameterSet parameters) {
        return new DriveItemCreateLinkRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.createLink"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemExtractSensitivityLabelsRequestBuilder extractSensitivityLabels() {
        return new DriveItemExtractSensitivityLabelsRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.extractSensitivityLabels"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemFollowRequestBuilder follow() {
        return new DriveItemFollowRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.follow"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemInviteCollectionRequestBuilder invite(@Nonnull DriveItemInviteParameterSet parameters) {
        return new DriveItemInviteCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.invite"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemPermanentDeleteRequestBuilder permanentDelete() {
        return new DriveItemPermanentDeleteRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.permanentDelete"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemPreviewRequestBuilder preview(@Nonnull DriveItemPreviewParameterSet parameters) {
        return new DriveItemPreviewRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.preview"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemUnfollowRequestBuilder unfollow() {
        return new DriveItemUnfollowRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.unfollow"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemValidatePermissionRequestBuilder validatePermission(@Nonnull DriveItemValidatePermissionParameterSet parameters) {
        return new DriveItemValidatePermissionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.validatePermission"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemDeltaCollectionRequestBuilder delta() {
        return new DriveItemDeltaCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemDeltaCollectionRequestBuilder delta(@Nonnull DriveItemDeltaParameterSet parameters) {
        return new DriveItemDeltaCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemGetActivitiesByIntervalCollectionRequestBuilder getActivitiesByInterval() {
        return new DriveItemGetActivitiesByIntervalCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.getActivitiesByInterval"), this.getClient(), null);
    }

    @Nonnull
    public DriveItemGetActivitiesByIntervalCollectionRequestBuilder getActivitiesByInterval(@Nonnull DriveItemGetActivitiesByIntervalParameterSet parameters) {
        return new DriveItemGetActivitiesByIntervalCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.getActivitiesByInterval"), this.getClient(), null, parameters);
    }

    @Nonnull
    public DriveItemSearchCollectionRequestBuilder search(@Nonnull DriveItemSearchParameterSet parameters) {
        return new DriveItemSearchCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("microsoft.graph.search"), this.getClient(), null, parameters);
    }
}

