// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.externalconnectors.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.externalconnectors.models.ExternalItem;
import com.microsoft.graph.externalconnectors.models.ExternalActivity;
import com.microsoft.graph.externalconnectors.models.ExternalActivityResult;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.externalconnectors.models.ExternalItemAddActivitiesParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the External Item Request Builder.
 */
public class ExternalItemRequestBuilder extends BaseRequestBuilder<ExternalItem> {

    /**
     * The request builder for the ExternalItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ExternalItemRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ExternalItemRequest instance
     */
    @Nonnull
    public ExternalItemRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the ExternalItemRequest instance
     */
    @Nonnull
    public ExternalItemRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.externalconnectors.requests.ExternalItemRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the ExternalActivity collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.externalconnectors.requests.ExternalActivityCollectionRequestBuilder activities() {
        return new com.microsoft.graph.externalconnectors.requests.ExternalActivityCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("activities"), getClient(), null);
    }

    /**
     * Gets a request builder for the ExternalActivity item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.externalconnectors.requests.ExternalActivityRequestBuilder activities(@Nonnull final String id) {
        return new com.microsoft.graph.externalconnectors.requests.ExternalActivityRequestBuilder(getRequestUrlWithAdditionalSegment("activities") + "/" + id, getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder collection
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public ExternalItemAddActivitiesCollectionRequestBuilder addActivities(@Nonnull final ExternalItemAddActivitiesParameterSet parameters) {
        return new ExternalItemAddActivitiesCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.externalConnectors.addActivities"), getClient(), null, parameters);
    }
}
